#ifndef _SCOREELEMENT_H_
#define _SCOREELEMENT_H_

#include "position.h"
#include "scoreObject.h"

class Note;
class PrScoreEditor;
class Tuplet;

/** This is an abstract class. Concrete implementations are ScoreBreaks and ScoreChords
 */
class ScoreElement : public ScoreObject
{
 protected:
  Position _start;
  long     _dur;
  int      _disp;
  Tuplet * _tuplet;

 public:
  ScoreElement();

  virtual ~ScoreElement();

  virtual void add(Note*,Position,long,int,bool)=0;

  virtual const Position & start() const;

  virtual long end() const;

  virtual long duration() const;

  virtual int display() const;

  virtual void setStart(Position);

  virtual void snapStart(int);

  virtual void setDuration(long);

  virtual void setDisplay(int);

  virtual void paint(PrScoreEditor * ed, int x=0, int y=0, int style=0)=0;

  virtual void print(PrScoreEditor * ed, int x=0, int y=0)=0;

  virtual bool isBreak() const = 0;

  virtual bool isChord() const = 0;

  virtual bool hasNoFlags() const = 0;
};

#endif

