#include "includes.h"

char *partition_type[NUM_PART_TYPES] = {
    [TYPE_LINUX_MINIX] 	= "Linux/MINIX",
    [TYPE_SWAP]  	= "Linux Swap",
    [TYPE_LINUX]       	= "Linux",
    [TYPE_FREE_SPACE]  	= "Free Space",
    [TYPE_EXTENDED]	= "Extended",
    [TYPE_LINEXT] 	= "Linux extended",
    [0x01]        	= "DOS FAT12",
    [0x02]        	= "XENIX root",
    [0x03]        	= "XENIX usr",
    [0x04]        	= "FAT16 (small)",
    [0x06]        	= "FAT16 (big)",
    [TYPE_NTFS]   	= "NTFS",
    [0x08]        	= "AIX",
    [0x09]        	= "AIX bootable",
    [0x0A]        	= "OS/2 BM",
    [0x0B]        	= "FAT32",
    [0x0C]        	= "FAT32 (LBA)",
    [0x0E]        	= "FAT16 (LBA)",
    [TYPE_MSEXT]       	= "Extended (LBA)",
    [0x11]        	= "Hidden FAT12",
    [0x14]       	= "Hidden FAT16 small",
    [0x16]        	= "Hidden FAT16 big",
    [0x17]        	= "Hidden NTFS",
    [0x40]        	= "Venix 80286",
    [0x41]	  	= "PPC PReP boot",
    [0x51]        	= "Novell?",
    [0x52]        	= "Microport",
    [0x63]        	= "GNU HURD",
    [0x64]        	= "Netware 286",
    [0x65]        	= "Netware 386",
    [0x75]        	= "PC/IX",
    [0x80]        	= "Old MINIX",
    [0x93]        	= "Amoeba",
    [0x94]        	= "Amoeba BBT",
    [0xA5]        	= "BSD/386",
    [0xA6]        	= "OpenBSD",
    [0xA7]        	= "NEXTSTEP",
    [0xB7]        	= "BSDI fs",
    [0xB8]        	= "BSDI swap",
    [0xC7]       	= "Syrinx",
    [0xDB]        	= "CP/M",
    [0xE1]        	= "DOS access",
    [0xE3]        	= "DOS R/O",
    [0xEB]	  	= "BeOS fs",
    [0xF2]        	= "DOS secondary",
    [0xFF]        	= "BBT"
};

char * typetostring(unsigned char type)
{
    static char retval[30];
    char * str;

    void masol(char *dest, char *source)
    {
	memcpy(dest,source,strlen(source)+1);
    }
    
    masol(retval,partition_type[type]);
    if (!retval)
    {
	asprintf(&str,"%x",type);
        masol(retval,str);
	free(str);
    }
    return retval;
}

