/***************************************************************************
 *   Copyright (C) 2003 by Sbastien Laot                                 *
 *   sebastien.laout@tuxfamily.org                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef SETTINGS_H
#define SETTINGS_H

#include <qstring.h>
#include <kdialogbase.h>
#include <qcheckbox.h>
#include <qcombobox.h>
#include <qtooltip.h>
#include <qcolor.h>
#include <qpoint.h>
#include <qsize.h>

#include "global.h"
#include "container.h"

class QGroupBox;
class QButtonGroup;
class KColorCombo;
class KIntNumInput;
class KGlobalAccel;
class QLabel;

class Container;
class ContainerSystemTray;
class DebugWindow;
class LinkLook;
class LinkLookEditWidget;
class RunCommandRequester;
class IconSizeCombo;

/** Handle all global variables (to avoid lot of extern declarations)
  * @author Sbastien Laot
  */
class Settings // FIXME: Distaptch new config events ?
{
  protected:
	/** Main window */                  // FIXME: Move ones of those properties in Container
	static bool s_tabsOnTop;
	static bool s_searchOnTop;
	static bool s_onlyBasketsIcon;
	static bool s_showItemsToolTip;
	static int  s_dropTimeToShow;
	static bool s_instantToolTips;
	static bool s_usePassivePopup;
	static int  s_middleAction;         // O:Nothing ; 1:Paste ; 2:Text ; 3:Html ; 4:Image ; 5:Link ; 6:Launcher ; 7:Color
	static int  s_writingAction;        // O:Nothing ; 1:Search ; 2:Text ; 3:Html ; 4:Link
	static int  s_writingCommaAction;   // O:Same ; 1:Search ; 2:Text ; 3:Html ; 4:Link
	static int  s_clickConf;            // O:Double ; 1:Single ; 2:KDE
	static bool s_useInlineEditors;
	static bool s_enterValidateInline;
	static bool s_clickCopyToSelection;
	static int  s_lastBasket;
	static QPoint s_mainWindowPosition;
	static QSize  s_mainWindowSize;
	static bool s_showEmptyBasketInfo;
	static bool s_blinkedSearch;
	/** System tray icon */
	static bool s_useSystray;
/*	static bool s_wasShown;*/
	static bool s_showIconInSystray;
	static bool s_startDocked;
	static bool s_hideOnMouseOut;
	static int  s_timeToHideOnMouseOut;
	static bool s_showOnMouseIn;
	static int  s_timeToShowOnMouseIn;
	/** Programs */
	static bool    s_textUseProg;
	static bool    s_htmlUseProg;
	static bool    s_imageUseProg;
	static bool    s_animationUseProg;
	static bool    s_soundUseProg;
	static QString s_textProg;
	static QString s_htmlProg;
	static QString s_imageProg;
	static QString s_animationProg;
	static QString s_soundProg;
	/** Insert item Default Values */
	static int     s_defTextFont;
	static QColor  s_defTextColor;
//	static bool    s_defHtmlShowSource;
	static int     s_defImageX;
	static int     s_defImageY;
	static int     s_defIconSize;
  public:  /* And the following methods are just getter / setters */
	/** App settings GET */
	static inline bool tabsOnTop()            { return s_tabsOnTop;            }
	static inline bool searchOnTop()          { return s_searchOnTop;          }
	static inline bool onlyBasketsIcon()      { return s_onlyBasketsIcon;      }
	static inline bool showItemsToolTip()     { return s_showItemsToolTip;     }
	static inline bool blinkedSearch()        { return s_blinkedSearch;        }
	static inline bool useSystray()           { return s_useSystray;           }
/*	static inline bool wasShown()             { return s_wasShown;             }*/
	static inline bool showIconInSystray()    { return s_showIconInSystray;    }
	static inline bool startDocked()          { return s_startDocked;          }
	static inline int  middleAction()         { return s_middleAction;         }
	static inline int  writingAction()        { return s_writingAction;        }
	static inline int  writingCommaAction()   { return s_writingCommaAction;   }
	static inline int  clickConf()            { return s_clickConf;            }
	static inline bool useInlineEditors()     { return s_useInlineEditors;     }
	static inline bool enterValidateInline()  { return s_enterValidateInline;  }
	static inline bool hideOnMouseOut()       { return s_hideOnMouseOut;       }
	static inline int  timeToHideOnMouseOut() { return s_timeToHideOnMouseOut; }
	static inline bool showOnMouseIn()        { return s_showOnMouseIn;        }
	static inline int  timeToShowOnMouseIn()  { return s_timeToShowOnMouseIn;  }
	static inline int  lastBasket()           { return s_lastBasket;           }
	static inline int  dropTimeToShow()       { return s_dropTimeToShow;       }
	static inline bool instantToolTips()      { return s_instantToolTips;      }
	static inline bool usePassivePopup()      { return s_usePassivePopup;      }
	static inline bool clickCopyToSelection() { return s_clickCopyToSelection; }
	static inline QPoint mainWindowPosition() { return s_mainWindowPosition;   }
	static inline QSize  mainWindowSize()     { return s_mainWindowSize;       }
	static inline bool showEmptyBasketInfo()  { return s_showEmptyBasketInfo;  }
	/** Programs */
	static inline bool    isTextUseProg()     { return s_textUseProg;          }
	static inline bool    isHtmlUseProg()     { return s_htmlUseProg;          }
	static inline bool    isImageUseProg()    { return s_imageUseProg;         }
	static inline bool    isAnimationUseProg(){ return s_animationUseProg;     }
	static inline bool    isSoundUseProg()    { return s_soundUseProg;         }
	static inline QString textProg()          { return s_textProg;             }
	static inline QString htmlProg()          { return s_htmlProg;             }
	static inline QString imageProg()         { return s_imageProg;            }
	static inline QString animationProg()     { return s_animationProg;        }
	static inline QString soundProg()         { return s_soundProg;            }
	/** Insert item Default Values */
	static inline int     defTextFont()       { return s_defTextFont;          }
	static inline QColor  defTextColor()      { return s_defTextColor;         }
//	static inline bool    defHtmlShowSource() { return s_defHtmlShowSource;    }
	static inline int     defImageX()         { return s_defImageX;            }
	static inline int     defImageY()         { return s_defImageY;            }
	static inline int     defIconSize()       { return s_defIconSize;          }
	/** App settings SET */
	static void setTabsOnTop(bool onTop)
	{
		s_tabsOnTop = onTop;
		if (Global::mainContainer)
			Global::mainContainer->tabPlacementChanged(onTop);
	}
	static void setSearchOnTop(bool onTop)
	{
		if (s_searchOnTop != onTop) {
			s_searchOnTop = onTop;
			if (Global::mainContainer)
				Global::mainContainer->searchPlacementChanged(onTop);
		}
	}
	static void setOnlyBasketsIcon(bool onlyIcons)
	{
		if (s_onlyBasketsIcon != onlyIcons) {
			s_onlyBasketsIcon = onlyIcons;
			if (Global::mainContainer)
				Global::mainContainer->updateTabs();
		}
	}
	static void setShowItemsToolTip(bool show)
	{
		if (s_showItemsToolTip != show) {
			s_showItemsToolTip = show;
			if (Global::mainContainer)
				Global::mainContainer->showItemsToolTipChanged();
		}
	}
	static void setUseSystray(bool useSystray)
	{
		if (s_useSystray != useSystray) {
			s_useSystray = useSystray;
			if (Global::tray != 0L) {
				if (Settings::useSystray())
					Global::tray->show();
				else {
					Global::tray->hide();
					Global::mainContainer->show();
				}
			}
			if (Global::mainContainer)
				Global::mainContainer->m_actHideWindow->setEnabled(useSystray);
		}
	}
	static void setShowIconInSystray(bool show)
	{
		if (s_showIconInSystray != show) {
			s_showIconInSystray = show;
			if (Global::tray != 0L && Settings::useSystray())
				Global::tray->updateToolTip();
		}
	}
	static inline void setBlinkedSearch(bool blinked)    { s_blinkedSearch        = blinked;     }
/*	static inline void setWasShown(bool wasShown)        { s_wasShown             = wasShown;    }*/
	static inline void setStartDocked(bool docked)       { s_startDocked          = docked;      }
	static inline void setMiddleAction(int action)       { s_middleAction         = action;      }
	static inline void setWritingAction(int action)      { s_writingAction        = action;      }
	static inline void setWritingCommaAction(int action) { s_writingCommaAction   = action;      }
	static inline void setClickConf(int conf)            { s_clickConf            = conf;        }
	static inline void setUseInlineEditors(bool use)     { s_useInlineEditors     = use;         }
	static inline void setEnterValidateInline(bool yes)  { s_enterValidateInline  = yes;         }
	static inline void setHideOnMouseOut(bool hide)      { s_hideOnMouseOut       = hide;        }
	static inline void setTimeToHideOnMouseOut(int time) { s_timeToHideOnMouseOut = time;        }
	static inline void setShowOnMouseIn(bool show)       { s_showOnMouseIn        = show;        }
	static inline void setTimeToShowOnMouseIn(int time)  { s_timeToShowOnMouseIn  = time;        }
	static inline void setLastBasket(int lastBasket)     { s_lastBasket           = lastBasket;  }
	static inline void setDropTimeToShow(int time)       { s_dropTimeToShow       = time;        }
	static void setInstantToolTips(bool enable)
	{
		s_instantToolTips = enable;
		QToolTip::setWakeUpDelay(enable ? 0 : 700); // FIXME: How to get this value from user preferences ?
	}
	static inline void setUsePassivePopup(bool enable)          { s_usePassivePopup      = enable; }
	static inline void setClickCopyToSelection(bool yes)        { s_clickCopyToSelection = yes;    }
	static inline void setMainWindowPosition(const QPoint &pos) { s_mainWindowPosition   = pos;    }
	static inline void setMainWindowSize(const QSize &size)     { s_mainWindowSize       = size;   }
	static inline void setShowEmptyBasketInfo(bool show)        { s_showEmptyBasketInfo  = show;   }
	// Programs :
	static inline void setIsTextUseProg(bool useProg)        { s_textUseProg      = useProg; }
	static inline void setIsHtmlUseProg(bool useProg)        { s_htmlUseProg      = useProg; }
	static inline void setIsImageUseProg(bool useProg)       { s_imageUseProg     = useProg; }
	static inline void setIsAnimationUseProg(bool useProg)   { s_animationUseProg = useProg; }
	static inline void setIsSoundUseProg(bool useProg)       { s_soundUseProg     = useProg; }
	static inline void setTextProg(const QString &prog)      { s_textProg         = prog;    }
	static inline void setHtmlProg(const QString &prog)      { s_htmlProg         = prog;    }
	static inline void setImageProg(const QString &prog)     { s_imageProg        = prog;    }
	static inline void setAnimationProg(const QString &prog) { s_animationProg    = prog;    }
	static inline void setSoundProg(const QString &prog)     { s_soundProg        = prog;    }
	// Insert item Default Values :
	static inline void setDefTextFont(int val)        { s_defTextFont       = val; }
	static inline void setDefTextColor(QColor val)    { s_defTextColor      = val; }
//	static inline void setDefHtmlShowSource(bool val) { s_defHtmlShowSource = val; }
	static inline void setDefImageX(int val)          { s_defImageX         = val; }
	static inline void setDefImageY(int val)          { s_defImageY         = val; }
	static inline void setDefIconSize(int val)        { s_defIconSize       = val; }
  public:
	/* Save and load config */
	static void loadConfig();
	static void saveConfig();
  protected:
	static void loadLinkLook(LinkLook* &look, const QString &name, LinkLook *defaultL);
	static void saveLinkLook(LinkLook *look, const QString &name);
  public:
	static bool singleClick();
};

/** Provide a dialog for modify application settings
  * @author Sbastien Laot
  */
class SettingsDialog : public KDialogBase
{
  Q_OBJECT
  public:
	SettingsDialog(QWidget *parent = 0);
	~SettingsDialog();
  protected slots:
	void clickConfChanged(int conf);
	void visualize();
	void showSelectionHelp();
	void showNewLineHelp();
	void slotDefault();
	void slotApply();
	void slotOk();
  private:
	void setupItemsDefaultValuesPage(QWidget *parent);
	// Main window
	QComboBox           *m_tabsOnTop;
	QComboBox           *m_searchOnTop;
	QCheckBox           *m_onlyBasketsIcon;
	QCheckBox           *m_showItemsToolTip;
	QCheckBox           *m_instantToolTips;
	QCheckBox           *m_usePassivePopup;
	QComboBox           *m_middleAction;
	QComboBox           *m_writingAction;
	QComboBox           *m_writingCommaAction;
	QComboBox           *m_clickConf;
	QCheckBox           *m_useInlineEditors;
	QCheckBox           *m_enterValidateInline;
	QWidget             *m_enterValidateInlineWidget;
	QButtonGroup        *m_itemClickCopy;
	QWidget             *m_helpLabel;
	QGroupBox           *m_gbClickToCopy;
	QLabel              *m_lblClickToCopy;
	// System Tray Icon
	QCheckBox           *m_useSystray;
	QCheckBox           *m_showIconInSystray;
	QWidget             *m_systray;
	QCheckBox           *m_hideOnMouseOut;
	KIntNumInput        *m_timeToHideOnMouseOut;
	QCheckBox           *m_showOnMouseIn;
	KIntNumInput        *m_timeToShowOnMouseIn;
	// Items Default Values
	QComboBox           *m_font;
	KColorCombo         *m_color;
//	QCheckBox           *m_showHtmlSource;
	KIntNumInput        *m_imgSizeX;
	KIntNumInput        *m_imgSizeY;
	QPushButton         *m_pushVisualize;
	IconSizeCombo       *m_iconSize;
	// Links
	LinkLookEditWidget  *m_soundLC;
	LinkLookEditWidget  *m_fileLC;
	LinkLookEditWidget  *m_localLC; // TODO FIXME: m_localLinkLC
	LinkLookEditWidget  *m_urlLC;   // TODO FIXME: m_networkLinkLC
	LinkLookEditWidget  *m_noUrlLC; // TODO FIXME: m_launcherLC
	// Programs
	QCheckBox           *m_textUseProg;
	QCheckBox           *m_htmlUseProg;
	QCheckBox           *m_imageUseProg;
	QCheckBox           *m_animationUseProg;
	QCheckBox           *m_soundUseProg;
	RunCommandRequester *m_textProg;
	RunCommandRequester *m_htmlProg;
	RunCommandRequester *m_imageProg;
	RunCommandRequester *m_animationProg;
	RunCommandRequester *m_soundProg;
};

#endif // SETTINGS_H
