/***************************************************************************
 *   Copyright (C) 2003 by Sbastien Laot                                 *
 *   sebastien.laout@tuxfamily.org                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "focusedwidgets.h"

/** class FocusedTextEdit */

FocusedTextEdit::FocusedTextEdit(bool escapeOnReturn, bool disableUpdatesOnKeyPress, QWidget *parent, const char *name)
 : KTextEdit(parent, name),
   m_escapeOnReturn(escapeOnReturn),
   m_disableUpdatesOnKeyPress(disableUpdatesOnKeyPress)
{
}

FocusedTextEdit::~FocusedTextEdit()
{
}

void FocusedTextEdit::keyPressEvent(QKeyEvent *event)
{
	if (event->key() == Qt::Key_Escape)
		emit escapePressed();
	else if (m_escapeOnReturn && event->key() == Qt::Key_Return && event->state() == 0)
		emit escapePressed();
	// In RichTextFormat mode, [Return] create a new paragraphe.
	// To keep consistency with TextFormat mode (new line on [Return]),
	// we redirect [Return] to simulate [Ctrl+Return] (create a new line in both modes).
	// Create new paragraphes still possible in RichTextFormat mode with [Shift+Enter].
	else if (event->key() == Qt::Key_Return && event->state() == 0)
		event = new QKeyEvent(QEvent::KeyPress, event->key(), event->ascii(), Qt::ControlButton,
		                      event->text(), event->isAutoRepeat(), event->count() );

	if (m_disableUpdatesOnKeyPress)
		setUpdatesEnabled(false);
	KTextEdit::keyPressEvent(event);
	if (m_disableUpdatesOnKeyPress) {
		setUpdatesEnabled(true);
		ensureCursorVisible();
		updateContents();
	}
}

void FocusedTextEdit::focusOutEvent(QFocusEvent*)
{
	emit focusOut();
}

#include "focusedwidgets.moc"
