/***************************************************************************
 *   Copyright (C) 2003 by Sbastien Laot                                 *
 *   sebastien.laout@tuxfamily.org                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef ADDBASKETWIZARD_H
#define ADDBASKETWIZARD_H

#include <kwizard.h>

class QVBox;
class QWidget;
class QLabel;
class QCheckBox;
class QButtonGroup;
class KLineEdit;
class QTextBrowser;
class KURLRequester;

/** Wizard to choose a type for a new basket, eventually populate it
  * with initial contents and / or give it a name.
  * @author Sbastien Laot
  */
class AddBasketWizard : public KWizard
{
  Q_OBJECT
  public:
	AddBasketWizard(QWidget *parent = 0, const char *name = 0);
	~AddBasketWizard();
  protected:
	void setupTypePage();
	void setupMirrorPage();
	void setupNamePage();
	void showPage(QWidget* page);
	int choosenType();     // Type page
	QString choosenName(); // Name page
  private:
	void addStretch(QWidget *parent);
	QVBox *m_typePage;
	QVBox *m_mirrorPage;
	QVBox *m_namePage;
	// Type page :
	QButtonGroup  *m_types;
	// Mirror page :
	KURLRequester *m_url;
	QCheckBox     *m_onlyNewFiles;
	QLabel        *m_mirrorState;
	QCheckBox     *m_reopenMirror;
	bool           m_mirrorPathError;
	// Name page :
	KLineEdit     *m_name;
	bool           m_shouldChooseAnotherName;
  private slots:
	// Type page :
	void typeChanged(int type);
	// Mirror page :
	void mirrorChanged(const QString&);
	void mirrorReopenChanged();
	// Name page :
	void nameChanged(const QString &name);
	// Finish :
	void accept();
};

#endif // ADDBASKETWIZARD_H
