# Arch Perl library, Copyright (C) 2004 Mikhael Goikhman
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

use 5.005;
use strict;

package AXP::Command::self::completion::zsh;
use base 'AXP::Command::self::completion';

sub collect_args {
	my $command = shift;
	my $prefix = $command->{prefix};
	my $level = ($prefix =~ s/ /_/g) || 0;
	$prefix .= "_" if $level == 0;

	my %options = $command->all_options;
	my @options = sort keys %options;

	# calculate completion for subcommands of the current command
	my $subcommand_string = "";
	if ($command->has_subcommands) {
		my @subcommands = $command->all_subcommands;
		# support "tree" subcommands on the first level too
		push @subcommands,
			grep { $_->{name} ne "help" }
				$command->get_subcommand("tree")->all_subcommands
			if $level == 0;
		foreach my $subcommand (@subcommands) {
			my $infoline = $subcommand->infoline;
			$infoline =~ s/'/'"'"'/g;
			$subcommand_string .= qq(
					"$subcommand->{name}:$infoline");
		}
		$subcommand_string = "
				':subcommands:(($subcommand_string
				))' \\";
		$subcommand_string =~ s/^\n$//;
	}

	# generate completion function for the current command
	my $fix_words_str = "; shift words"  x $level;
	my $string = "
		function _$prefix {
			(( CURRENT -= $level ))$fix_words_str
			_arguments \\$subcommand_string
	";
	$string =~ s/\t$//;
	# add options of the current command
	$string .= join('', map {
		my $option = $command->long_option($_);
		my $desc = $options{$_}->{desc};
		$desc =~ s/'/'"'"'/g;
		"\t\t\t\t'$option\[$desc]' \\\n"
	} @options);
	$string .= "
		}
	";

	return $string;
}

sub execute {
	my $self = shift;
	my $string = join('', $self->{root}->foreach_subcommand(\&collect_args));
	$string = q(
		#compdef axp

		local prefix
		prefix=$words[2,-2]
		prefix=$prefix:gs/\ /_/
	) . $string . q(
		if typeset -f _axp_$prefix &>/dev/null; then
			_axp_$prefix
		elif typeset -f _axp_tree_$prefix &>/dev/null; then
			(( CURRENT++ )); words[2,1]=tree
			_axp_tree_$prefix
		else
			_arguments '*:: :_files'
		fi
	);
	$string =~ s/\t$//;
	$string =~ s/\n\t\t?/\n/g;
	$string =~ s/^\n//;
	$self->write($string);
}

1;
