/****************************************************************
**
** Attal : Lords of Doom
**
** previewBaseDialog.cpp
** dialog for preview of a base with buildings
**
** Version : $Id: previewBaseDialog.cpp,v 1.4 2003/08/20 12:22:59 audoux Exp $
**
** Author(s) : Pascal Audoux
**
** Date : 28/06/2003
**
** Licence :
**	This program is free software; you can redistribute it and/or modify
**   	it under the terms of the GNU General Public License as published by
**     	the Free Software Foundation; either version 2, or (at your option)
**      any later version.
**
**	This program is distributed in the hope that it will be useful,
** 	but WITHOUT ANY WARRANTY; without even the implied warranty of
**	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**	GNU General Public License for more details.
**
****************************************************************/

#include "previewBaseDialog.h"
 
// generic include files
// include files for QT
#include <qlayout.h>
#include <qlistview.h>
// application specific include files
#include "libCommon/dataTheme.h"
#include "libCommon/genericBase.h"
#include "libCommon/genericInsideBuilding.h"

#include "libClient/gui.h"
#include "libClient/insideBase.h"

extern DataTheme DataTheme;

PreviewBaseDialog::PreviewBaseDialog( QWidget * parent, const char * name )
: QDialog( parent, name, true )
{
	_base = 0;

	_inside = new InsideBase( this );
	InsideBaseView * view = new InsideBaseView( _inside, this );

	_listBuilding = new QListView( this );
	_listBuilding->addColumn( tr( "Buildings" ) );
	_listBuilding->setSorting( -1 );


	QHBoxLayout * layout = new QHBoxLayout( this );
	layout->addWidget( view, 1 );
	layout->addWidget( _listBuilding );
	layout->activate();

	connect( _listBuilding, SIGNAL( clicked( QListViewItem * ) ), SLOT( slot_clickBuilding( QListViewItem * ) ) );
}

PreviewBaseDialog::~PreviewBaseDialog()
{
	delete _base;
}

void PreviewBaseDialog::init( GenericBaseModel * model )
{
	delete _base;

	_base = new GenericBase();
	_base->setRace( model->getRace() );
	_inside->setBase( _base );

	_listBuilding->clear();
	for( int i = DataTheme.bases.at( _base->getRace() )->getBuildingCount() - 1; i >= 0; i-- ) {
		InsideBuildingModel * building = DataTheme.bases.at( _base->getRace() )->getBuildingModel( i );
		new QCheckListItem( _listBuilding, building->getName(), QCheckListItem::CheckBox );
	}
	FIXEDSIZE( _listBuilding );
}

void PreviewBaseDialog::slot_clickBuilding( QListViewItem * item )
{
	QCheckListItem * check = (QCheckListItem *)item;
	int i = 0;
	QListViewItemIterator ite( _listBuilding );
	for( ite.current(); ite.current(); ++ite ) {
		if( ( (QCheckListItem*) ite.current() ) == check ) {
			break;
		}
		i++;
	}

	if( check->isOn() ) {
		_base->addBuilding( i );
		GenericInsideBuilding * build = _base->getBuildingByType( i );
		_inside->addBuilding( build );
	} else {
		GenericInsideBuilding * build = _base->getBuildingByType( i );
		_inside->delBuilding( build );
		_base->removeBuildingType( i );
	}
	_inside->update();
}



