/****************************************************************
**
** Attal : Lords of Doom
**
** mapDispositionEditor.h
** Edit map disposition
**
** Version : $Id: mapDispositionEditor.h,v 1.4 2004/07/31 10:30:21 audoux Exp $
**
** Author(s) : Pascal Audoux
**
** Date : 22/07/2004
**
** Licence :
**	This program is free software; you can redistribute it and/or modify
**   	it under the terms of the GNU General Public License as published by
**     	the Free Software Foundation; either version 2, or (at your option)
**      any later version.
**
**	This program is distributed in the hope that it will be useful,
** 	but WITHOUT ANY WARRANTY; without even the implied warranty of
**	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**	GNU General Public License for more details.
**
****************************************************************/


#ifndef MAPDISPOSITIONEDITOR_H
#define MAPDISPOSITIONEDITOR_H

// generic include files
// include files for QT
#include <qcanvas.h>
#include <qpainter.h>
#include <qwidget.h>
// application specific include files
#include "libCommon/genericMapDisposition.h"

class QSpinBox;

class DispositionSprite;
class MapDispositionCanvas;
class MapDispositionCanvasView;

/*              ------------------------------
 *                   MapDispositionEditor
 *              ------------------------------ */

class MapDispositionEditor : public QWidget
{
	Q_OBJECT
public:
	/** Constructor */
	MapDispositionEditor( QWidget * parent = 0, const char * name = 0 );

	void init( GenericMapDisposition * mapDisposition, const QString & pixmapPath );
	
	void clear();

public slots:
	void slot_clicked( int id );
	void slot_resize();

protected:
	GenericMapDisposition * _mapDisposition;
	QString _pixmapPath;
	MapDispositionCanvas * _dispositionCanvas;
	MapDispositionCanvasView * _dispositionCanvasView;
	QSpinBox * _spinCol, * _spinRow;
};

/*              ------------------------------
 *                   MapDispositionCanvas
 *              ------------------------------ */
class MapDispositionCanvas : public QCanvas
{
public:
	/** Constructor */
	MapDispositionCanvas( QObject * parent = 0, const char * name = 0 );

	virtual ~MapDispositionCanvas();

	void changeCell( uint row, uint col );

	void init( GenericMapDisposition * mapDisposition, const QString & pixmapPath );

	void reinit();

	QCanvasPixmapArray * getPixmaps() { return _pixmaps; }

	void setCurrentType( GenericMapDisposition::DispositionType type ) { _currentType = type; }
	
	void clear();

protected:
	DispositionSprite * _background;
	QCanvasPixmapArray * _pixmaps;
	GenericMapDisposition * _disposition;
	GenericMapDisposition::DispositionType _currentType;
	DispositionSprite *** _dispositionSprites;
};

/*              ------------------------------
 *                 MapDispositionCanvasView
 *              ------------------------------ */
class MapDispositionCanvasView : public QCanvasView
{
public:
	/** Constructor */
	MapDispositionCanvasView( MapDispositionCanvas * canvas , QWidget * parent = 0, const char * name = 0, WFlags f = 0 );

protected:
	void contentsMouseReleaseEvent( QMouseEvent * e );

	MapDispositionCanvas * _canvas;
};

/*              ------------------------------
 *                    DispositionSprite
 *              ------------------------------ */
class DispositionSprite : public QCanvasSprite
{

public:
	/** Constructor */
	DispositionSprite( MapDispositionCanvas * );

	void setType( GenericMapDisposition::DispositionType type );
	
	void setBackground( const QString & pixmapPath );

	/** Return RTTI */
	int rtti() const { return RTTI; };

	static const int RTTI;

protected:
	GenericMapDisposition::DispositionType _type;
};

#endif // MAPDISPOSITIONEDITOR_H
