/****************************************************************
**
** Attal : Lords of Doom
**
** gameDescription.h
** description of game info
**
** Version : $Id: gameDescription.h,v 1.6 2004/09/09 21:43:01 audoux Exp $
**
** Author(s) : Pascal Audoux
**
** Date : 07/01/2001
**
** Licence :    
**	This program is free software; you can redistribute it and/or modify
**   	it under the terms of the GNU General Public License as published by
**     	the Free Software Foundation; either version 2, or (at your option)
**      any later version.
**
**	This program is distributed in the hope that it will be useful,
** 	but WITHOUT ANY WARRANTY; without even the implied warranty of
**	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**	GNU General Public License for more details.
**
****************************************************************/

 
#ifndef GAMEDESCRIPTION_H
#define GAMEDESCRIPTION_H
 
 
// generic include files
// include files for QT
#include <qstring.h>
#include <qcolor.h>
#include <qpixmap.h>
#include <qptrlist.h>
// application specific include files
#include "libCommon/genericLord.h"

#include "libClient/lord.h"
#include "libClient/graphicalArtefact.h"

class Calendar;
class GenericPlayer;

 
/*              ------------------------------
 *                         GameDescription
 *              ------------------------------ */


class GameDescription
{
 
public:
	/** Construtor */
	GameDescription();

	/** Virtual destructor */
	virtual ~GameDescription();
	
	/** Set number of players */
	void setPlayerNumber( uint nb ); 
	
	/** Return the number of players */
	uint getPlayerNumber();
	
	GenericPlayer * getPlayer( uint num );
	
	/** Init lords for the game */
	void initLords();
	
	void reInitLords();
	
	/** Init bases for the game */
	//void initBases();

	GenericLord * getLord( int id ) {
		return _realLords[id];
	}

	Artefact * getArtefactById( int id );
	
protected:
	Calendar * _calendar;
	QString * _playersName;
	Lord ** _realLords;
	QPtrList<Artefact> _artefacts;
	QPtrList<GenericPlayer> _players;
};
 
#endif // GAMEDESCRIPTION_H   
