/****************************************************************
**
** Attal : Lords of Doom
**
** attalSound.cpp
** Manage sound and music (or not) for attal client
**
** Version : $Id: attalSound.cpp,v 1.9 2004/08/08 15:45:20 audoux Exp $
**
** Author(s) : Pascal Audoux
**
** Date : 22/09/2003
**
** Licence :
**	This program is free software; you can redistribute it and/or modify
**   	it under the terms of the GNU General Public License as published by
**     	the Free Software Foundation; either version 2, or (at your option)
**      any later version.
**
**	This program is distributed in the hope that it will be useful,
** 	but WITHOUT ANY WARRANTY; without even the implied warranty of
**	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**	GNU General Public License for more details.
**
****************************************************************/

#ifdef WITH_SOUND

#include "attalSound.h"

// generic include files
#include <stdlib.h>
// include files for QT
#include <qstring.h>
// application specific include files

extern QString MUSIC_PATH;

extern QString SOUND_PATH;

AttalSound::AttalSound()
{
	_music = 0;
	_enabled = true;
	_soundId = -1;
	_sound = 0;
}

AttalSound::~AttalSound()
{
	clear();
}

void AttalSound::enableSound()
{
	_enabled = true;
}

void AttalSound::disableSound()
{
	_enabled = false;
}

bool AttalSound::isSoundEnabled()
{
	return _enabled;
}

void AttalSound::init()
{
	if ( SDL_Init(SDL_INIT_AUDIO|SDL_INIT_VIDEO) < 0 ) {
		fprintf(stderr, "Couldn't initialize SDL: %s\n",SDL_GetError());
		exit(2);
	}

	if ( Mix_OpenAudio( 22050, AUDIO_S16, 2, 512) < 0 ) {
		fprintf(stderr,	"Warning: Couldn't set 11025 Hz 8-bit audio\n- Reason: %s\n", SDL_GetError() );
	}

	_music = Mix_LoadMUS( MUSIC_PATH + "map.ogg" );

	if( _music == NULL ) {
		fprintf(stderr, "Warning: Couldn't load music: %s\n", Mix_GetError() );
	}
}

void AttalSound::clear()
{
	if( _sound ) {
		Mix_HaltChannel( _soundId );
		delete( _sound );
		_soundId = -1;
		_sound = 0;
	}
	if( _music ) {
		Mix_FreeMusic( _music );
		Mix_CloseAudio();
		_music = 0;
	}
}

void AttalSound::playMusicMap()
{
	if( _enabled ) {
		if( Mix_PlayingMusic() ) {
			Mix_FadeOutMusic( 1000 );
		}
		Mix_Music * music = Mix_LoadMUS( MUSIC_PATH + "map.ogg" );
		Mix_PlayMusic( music, -1 );
		Mix_FreeMusic( _music );
		_music = music;
	}
}

void AttalSound::playMusicBase( uint /*race*/ )
{
	if( _enabled ) {
		if( Mix_PlayingMusic() ) {
			Mix_FadeOutMusic( 1000 );
		}
		Mix_Music * music = Mix_LoadMUS( MUSIC_PATH + "castle.ogg" );
		Mix_PlayMusic( music, -1 );
		Mix_FreeMusic( _music );
		_music = music;
	}
}

void AttalSound::playMusicFight()
{
	if( _enabled ) {
		if( Mix_PlayingMusic() ) {
			Mix_FadeOutMusic( 1000 );
		}
		Mix_Music * music = Mix_LoadMUS( MUSIC_PATH + "battle01.ogg" );
		Mix_PlayMusic( music, -1 );
		Mix_FreeMusic( _music );
		_music = music;
	}
}

QString AttalSound::computeSoundFile( SoundType snd )
{
	QString ret = "";
	
	switch( snd ) {
	case SND_HIT:
		ret = "hit.wav";
		break;
	case SND_ARROW:
		ret = "arrow.wav";
		break;
	case SND_GOOD:
		ret = "good.wav";
		break;
	case SND_WIN:
		ret = "win.wav";
		break;
	}
	
	return ret;
}

void AttalSound::playSound( SoundType snd )
{
	Mix_Chunk * sound;
	int soundId;
	QString file = computeSoundFile( snd );
	
	if( file != "" ) {
		if( _sound ) {
			Mix_HaltChannel( _soundId );
			delete( _sound );
		}	
		sound = Mix_LoadWAV( SOUND_PATH + file );
		soundId = Mix_PlayChannel( -1, sound, 0 );
				
		_sound = sound;
		_soundId = soundId;
	}
}


#endif
