// vs_scrollbar.h                         -*-c++-*-
//
//  Guess. >=)
//
//  Scrollbars in text-mode are, of course, only a visual effect, but they're
// useful nonetheless and a requested feature..

#ifndef VS_SCROLLBAR_H
#define VS_SCROLLBAR_H

#include "vscreen_widget.h"

class vs_scrollbar:public vscreen_widget
{
public:
  enum direction {HORIZONTAL, VERTICAL};

private:
  direction dir;

  int max, val;
  // The current slider maximum and value (FIXME: use floats?)

  /** Get the current X or Y location of the slider in the widget. 
   *
   *  \return the slider location, or -1 if it is not visible.
   */
  int get_slider();
public:
  vs_scrollbar(direction _dir, int _val, int _max)
    :dir(_dir), max(_max), val(_val) {}

  vs_scrollbar(direction _dir)
    :dir(_dir), max(0), val(0) {}

  void paint();
  size size_request();
  bool get_cursorvisible();
  point get_cursorloc();
  void dispatch_mouse(short id, int x, int y, int z, mmask_t bstate);

  void set_slider(int newval, int newmax);

  /** This signal is emitted if the user "pages up" or "pages down"
   *  via the scrollbar.  Its argument is \b true for a "page up" and
   *  \b false for a "page down".
   */
  SigC::Signal1<void, bool> scrollbar_interaction;
};

#endif
