// ---------------------------------------------------------------------------
// - t_inpmap.cpp                                                            -
// - standard object library - input mapped file class tester                -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2003 amaury darsch                                   -
// ---------------------------------------------------------------------------

#include "InputFile.hpp"
#include "InputMapped.hpp"

int main (int, char**) {
  using namespace aleph;

  // create an input mapped on ourself
  InputMapped ms ("t_inpmap.cpp");
  InputMapped fs ("t_inpmap.cpp");

  // get the file size
  long msize = ms.length ();
  long fsize = fs.length ();
  if (msize != fsize) return 1;

  // loop on character and check count
  long count = 0;
  while ((ms.iseof () == false) && (fs.iseof () == false)) {
    if (ms.read () != fs.read ()) return 1;
    count++;
  }
  if (count != msize) return 1;
  if (count != fsize) return 1;

  // everything is fine
  return 0;
}
