// ---------------------------------------------------------------------------
// - Libasys.cpp                                                             -
// - aleph:sys library - declaration & implementation                        -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2003 amaury darsch                                   -
// ---------------------------------------------------------------------------

#include "Meta.hpp"
#include "Time.hpp"
#include "Libasys.hpp"
#include "Predasys.hpp"
#include "Syscalls.hpp"
#include "Function.hpp"

namespace aleph {
  // initialize the sys library
  Object* init_aleph_sys (Interp* interp, Vector* argv) {
    // make sure we are not called from something crazy
    if (interp == nilp) return nilp;

    // create the aleph:sys nameset
    Nameset* aset = interp->mknset ("aleph", interp->getgset ());
    Nameset* asys = interp->mknset ("sys",   aset);

    // bind all classes in the aleph.sys nameset
    asys->symcst ("Time",               new Meta (Time::mknew));

    // bind all predicates in the aleph.sys nameset
    asys->symcst ("time-p",             new Function (asys_timep));

    // bind all syscalls in the aleph.sys nameset
    asys->symcst ("exit",               new Function (asys_exit));
    asys->symcst ("sleep",              new Function (asys_sleep));
    asys->symcst ("random",             new Function (asys_random));
    asys->symcst ("get-pid",            new Function (asys_getpid));
    asys->symcst ("get-env",            new Function (asys_getenv));
    asys->symcst ("get-host-name",      new Function (asys_hostname));
    asys->symcst ("get-user-name",      new Function (asys_username));

    // not used but needed
    return nilp;
  }
}

extern "C" {
  aleph::Object* dli_aleph_sys (aleph::Interp* interp, aleph::Vector* argv) {
    return init_aleph_sys (interp, argv);
  }
}
