# ---------------------------------------------------------------------------
# - net-0001.als                                                            -
# - aleph example : network library example                                 -
# ---------------------------------------------------------------------------
# - This program is free software;  you can redistribute it  and/or  modify -
# - it provided that this copyright notice is kept intact.                  -
# -                                                                         -
# - This program  is  distributed in  the hope  that it will be useful, but -
# - without  any  warranty;  without  even   the   implied    warranty   of -
# - merchantability or fitness for a particular purpose.  In no event shall -
# - the copyright holder be liable for any  direct, indirect, incidental or -
# - special damages arising in any way out of the use of this software.     -
# ---------------------------------------------------------------------------
# - copyright (c) 1999-2003 amaury darsch                                   -
# ---------------------------------------------------------------------------

# print the ip address information of the arguments
# usage: aleph 3101.als [hosts ...]

# get the network library
interp:library "aleph-net"
interp:library "aleph-sys"

# print the ip address
const ip-address-info (host) {
  try {
    const addr (aleph:net:Address host)
    println "host name        : " (addr:get-name)
    println "  ip address     : " (addr:get-ip-address)
    println "  canonical name : " (addr:get-canonical-name)
  } (errorln "error: " what:reason)
}

# get the hosts 
if (== (interp:argv:length) 0) {
  (ip-address-info (aleph:sys:get-host-name))
} {
  for (s) (interp:argv) (ip-address-info s)
}
