// ---------------------------------------------------------------------------
// - Globalset.hpp                                                           -
// - aleph engine - global set class definition                              -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2003 amaury darsch                                   -
// ---------------------------------------------------------------------------

#ifndef  ALEPH_GLOBALSET_HPP
#define  ALEPH_GLOBALSET_HPP

#ifndef  ALEPH_NAMESET_HPP
#include "Nameset.hpp"
#endif

#ifndef  ALEPH_QUARKTABLE_HPP
#include "QuarkTable.hpp"
#endif

namespace aleph {

  /// The Globalset class is a nameset designed to handle a large set of
  /// objects. Each object is associated with a symbol. Creating by quark
  /// automatically creates the symbol object. The evaluation automatically
  /// retreive the symbol by quark and return the object.
  /// @author amaury darsch

  class Globalset : public Nameset {
  private:
    QuarkTable* p_table;

  public:
    /// create a new global set
    Globalset (void);
    
    /// create a new global set with a parent nameset
    /// @param nset the parent nameset
    Globalset (Nameset* nset);

    /// destroy this globalset
    ~Globalset (void);

    /// @return the class name
    String repr (void) const;

    /// make this globalset a shared object
    void mksho (void);

    /// clear this global set
    void clear (void);

    /// add a new object by quark
    /// @param quark the object quark
    /// @param object the object to bind
    void bind (const long quark, Object* object);

    /// @return true if the qaurk exists in this global set
    bool exists (const long quark) const;

    /// @return an object by quark but do not evaluate
    Object* find (const long quark);

    /// remove an object by quark in this nameset
    /// @param quark the binding to remove
    void remove (const long quark);

    /// set an object as a const object by quark
    /// @param robj   the current runnable
    /// @param nset   the current nameset
    /// @param quark  the quark to bind this constant
    /// @param object the object to set
    Object* cdef (Runnable* robj, Nameset* nset, const long quark, 
		  Object* object);

    /// set an object to this object by quark
    /// @param robj   the current runnable
    /// @param nset   the current nameset
    /// @param quark  the quark to bind this object
    /// @param object the object to set
    Object* vdef (Runnable* robj, Nameset* nset, const long quark, 
		  Object* object);

    /// evaluate an object in the current nameset by quark
    /// @param robj   the current runnable
    /// @param nset   the current nameset
    /// @param quark  the quark to evaluate
    Object* eval (Runnable* robj, Nameset* nset, const long quark);

  private:
    // make the copy constructor private
    Globalset (const Globalset&);
    // make the assignment operator private
    Globalset& operator = (const Globalset&);
  };
}

#endif
