// ---------------------------------------------------------------------------
// - Main.cpp                                                                -
// - the aleph cross ompiler main program                                    -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2003 amaury darsch                                   -
// ---------------------------------------------------------------------------

#include "System.hpp"
#include "Interp.hpp"
#include "Axcopts.hpp"
#include "Exception.hpp"
#include "InputFile.hpp"
#include "OutputFile.hpp"
#include "OutputTerm.hpp"

// this procedure compile a file by name
static void compile (aleph::Interp* interp, const aleph::String& name) {
  using namespace aleph;

  // get the output file name
  String oname = System::xname (System::rmext (name)) + ".axc";
  try {
    // try to open the output file
    OutputFile os (oname);
    // compile the module
    interp->compile (name, os);
  } catch (const Exception& e) {
    OutputTerm terr;
    if (System::isfile (oname) == true) System::rmfile (oname);
    terr.errorln (e);
    System::exit (1);
  } 
}

// main interpreter 

int main (int argc, char** argv) {
  using namespace aleph;

  // create a new option instance
  Axcopts* options = new Axcopts (argc,argv);

  // create a new interpreter
  Interp* interp = new Interp;
  interp->setpath (options->getpath ());
  
  // get the argument file vector
  const Strvec& argf = options->getargv ();
  long  flen = argf.length ();

  // compile one by one
  try {
    for (long i = 0; i < flen; i++) compile (interp, argf.get (i));
  } catch (...) {
    OutputTerm terr;
    terr << "fatal: internal error\n";
    System::exit (1);
  }
  
  // clean eveything and return
  delete options;
  return 0;
}
