(in-package "ACL2")

(local (include-book "fl2"))
(local (include-book "integerp"))
(local (include-book "arith"))
(local (include-book "type"))
(local (include-book "arith2"))
(local (include-book "expt2"))
(local (include-book "mod"))
(local (include-book "mod2"))

(include-book "rtl")

(defun shft (x s l)
  (mod (fl (* (expt 2 s) x)) (expt 2 (nfix l))))

(in-theory (disable shft))

(defthm shft-nonnegative-integer-type
  (and (integerp (shft x s l))
       (<= 0 (shft x s l)))
  :rule-classes (:type-prescription))

;(:type-prescription shft) is no better than shft-nonnegative-integer-type and might be worse:
(in-theory (disable (:type-prescription shft)))

(defthm shft-natp
  (natp (shft x s n)))

(defthm shft-bvecp-simple
  (bvecp (shft x s n) n)
  :hints (("Goal" :in-theory (enable bvecp shft))))

(local (include-book "bvecp"))

(defthm shft-bvecp
  (implies (and (<= n k)
                (case-split (integerp k)))
           (bvecp (shft x s n) k))
  :hints (("Goal" :in-theory (disable shft-bvecp-simple)
           :use shft-bvecp-simple)))



