/*
 * Copyright (c) 2002, 2003 Red Hat, Inc. All rights reserved.
 *
 * This software may be freely redistributed under the terms of the
 * GNU General Public License.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Author: Liam Stewart
 * Component of: Visual Explain GUI tool for PostgreSQL - Red Hat Edition
 */

package com.redhat.rhdb.vise;

import java.awt.*;
import java.awt.color.*;
import javax.swing.*;

/**
 * Splash screen for Explain.
 *
 * @author <a href="mailto:liams@redhat.com">Liam Stewart</a>
 * @version 0.0
 */
public class SplashScreen extends JWindow {
	/**
	 * Creates a new <code>SplashScreen</code> instance.
	 *
	 * @param image a <code>String</code> value
	 */
	public SplashScreen(String image) {
		JPanel splash = new JPanel();
		splash.setBorder(BorderFactory.createLineBorder(Color.black));
		splash.setLayout(new BorderLayout());

 		ImageIcon pic = new ImageIcon(this.getClass().getResource(image));
		JLabel label = new JLabel(pic);

		splash.add(label, BorderLayout.CENTER);
		this.getContentPane().add(splash);
		pack();

		Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
		
		int h = getHeight();
		int w = getWidth();

		setLocation((screen.width - w) / 2, (screen.height -h) / 2);
	}
}// SplashScreen
