/* $Id: cd.c,v 1.5 2002/10/13 03:40:10 jaq Exp $
 *
 * used to be cd_linux.c
 *
 * Copyright (C) 1997-2001 Id Software, Inc.
 * Copyright (c) 2002 The Quakeforge Project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
 *
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

// Quake is a trademark of Id Software, Inc., (c) 1996 Id Software, Inc. All
// rights reserved.

/* cd_irix.c comments out just about all of this code, replacing the functions
 * with stubs... instead I'll leave the full implementations here and someone
 * can work out how to play cds under irix -- jaq */

#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <sys/ioctl.h>
#include <sys/file.h>
#include <sys/types.h>
#include <fcntl.h>
#include <string.h>
#include <time.h>
#include <errno.h>

/* merged in from cd_bsd.c -- jaq */
#ifdef __linux__
	#include <linux/cdrom.h>
#else /* __bsd__ */
	#include <sys/cdio.h>
	#include <sys/disklabel.h>
#endif

#include "client.h"

static qboolean cdValid = false;
static qboolean	playing = false;
static qboolean	wasPlaying = false;
static qboolean	initialized = false;
static qboolean	enabled = true;
static qboolean playLooping = false;
static float	cdvolume;
static byte 	remap[100];
static byte		playTrack;
static byte		maxTrack;

static int cdfile = -1;

//static char cd_dev[64] = "/dev/cdrom";

cvar_t *cd_volume;
cvar_t *cd_nocd;
cvar_t *cd_dev;

void CDAudio_Pause(void);


static void CDAudio_Eject(void)
{
	if (cdfile == -1 || !enabled)
		return; // no cd init'd

/* merged in from cd_bsd.c -- jaq */
#ifdef __linux__
	if ( ioctl(cdfile, CDROMEJECT) == -1 ) 
		Com_DPrintf("ioctl cdromeject failed\n");
#else /* bsd */
	if (ioctl(cdfile, CDIOCEJECT) == -1)
		Com_DPrintf("ioctl cdioeject failed\n");
#endif
}


static void CDAudio_CloseDoor(void)
{
	if (cdfile == -1 || !enabled)
		return; // no cd init'd

/* merged in from cd_bsd.c -- jaq */
#ifdef __linux__
	if ( ioctl(cdfile, CDROMCLOSETRAY) == -1 ) 
		Com_DPrintf("ioctl cdromclosetray failed\n");
#else /* bsd */
	/* No OpenBSD equivalent of this Linux ioctl() */
	Com_DPrintf("ioctl cdromclosetray not supported\n");
#endif
}

static int CDAudio_GetAudioDiskInfo(void)
{
/* merged in from cd_bsd.c */
#ifdef __linux__
	struct cdrom_tochdr tochdr;
#else /* bsd */
	struct ioc_toc_header tochdr;
#endif

	cdValid = false;

#ifdef __linux__
	if (ioctl(cdfile, CDROMREADTOCHDR, &tochdr) == -1) {
		Com_DPrintf("ioctl cdromreadtochdr failed\n");
		return -1;
	}
#else /* bsd */
	if (ioctl(cdfile, CDIOREADTOCHEADER, &tochdr) == -1) {
		Com_DPrintf("ioctl cdioreadtocheader failed\n");
		return -1;
	}
#endif

#ifdef __linux__
	if (tochdr.cdth_trk0 < 1)
#else /* bsd */
	if (tochdr.starting_track < 1)
#endif
	{
		Com_DPrintf("CDAudio: no music tracks\n");
		return -1;
	}

	cdValid = true;
#ifdef __linux__
	maxTrack = tochdr.cdth_trk1;
#else /* bsd */
	maxTrack = tochdr.ending_track;
#endif

	return 0;
}


void CDAudio_Play(int track, qboolean looping)
{
/* merged in from cd_bsd.c -- jaq */
#ifdef __linux__
	struct cdrom_tocentry entry;
	struct cdrom_ti ti;
#else /* bsd */
	struct ioc_read_toc_entry entry;
	struct cd_toc_entry cd_entry;
	struct ioc_play_track ti;
#endif

	if (cdfile == -1 || !enabled)
		return;
	
	if (!cdValid)
	{
		CDAudio_GetAudioDiskInfo();
		if (!cdValid)
			return;
	}

	track = remap[track];

	if (track < 1 || track > maxTrack)
	{
		Com_DPrintf("CDAudio: Bad track number %u.\n", track);
		return;
	}

	// don't try to play a non-audio track
#ifdef __linux__
	entry.cdte_track = track;
	entry.cdte_format = CDROM_MSF;
    if (ioctl(cdfile, CDROMREADTOCENTRY, &entry) == -1) {
		Com_DPrintf("ioctl cdromreadtocentry failed\n");
		return;
	}
#else /* bsd */
	entry.starting_track = track;
	entry.address_format = CD_MSF_FORMAT;
	entry.data_len = sizeof(struct cd_toc_entry);
	entry.data = &cd_entry;
	if (ioctl(cdfile, CDIOREADTOCENTRYS, &entry) == -1) {
		Com_DPrintf("ioctl cdioreadtocentrys failed\n");
		return;
	}
#endif

/* merged in from cd_bsd.c -- jaq */
#ifdef __linux__
	if (entry.cdte_ctrl == CDROM_DATA_TRACK)
#else /* bsd */
	#ifndef CDROM_DATA_TRACK
	#define CDROM_DATA_TRACK 4
	#endif

	if (cd_entry.control == CDROM_DATA_TRACK)
#endif
	{
		Com_Printf("CDAudio: track %i is not audio\n", track);
		return;
	}

	if (playing)
	{
		if (playTrack == track)
			return;
		CDAudio_Stop();
	}

#ifdef __linux__
	ti.cdti_trk0 = track;
	ti.cdti_trk1 = track;
	ti.cdti_ind0 = 1;
	ti.cdti_ind1 = 99;
	
	if (ioctl(cdfile, CDROMPLAYTRKIND, &ti) == -1) {
#else /* bsd */
	ti.start_track = track;
	ti.start_index = 1;
	ti.end_track = track;
	ti.end_index = 99;

	if (ioctl(cdfile, CDIOCPLAYTRACKS, &ti) == -1) {
#endif
		Com_DPrintf("ioctl cdromplaytrkind failed\n");
		return;
	}

#ifdef __linux__
	if ( ioctl(cdfile, CDROMRESUME) == -1 ) 
		Com_DPrintf("ioctl cdromresume failed\n");
#else /* bsd */
	if (ioctl(cdfile, CDIOCRESUME) == -1)
		Com_DPrintf("ioctl cdiocresume failed\n");
#endif

	playLooping = looping;
	playTrack = track;
	playing = true;

	if (cd_volume->value == 0.0)
		CDAudio_Pause ();
}

#ifdef __linux__
/* only because it hasn't been ported to bsd yet */
void CDAudio_RandomPlay(void)
{
	int track, i = 0, free_tracks = 0, remap_track;
	float f;
	unsigned char * track_bools;
	struct cdrom_tocentry entry;
	struct cdrom_ti ti;

	if (cdfile == -1 || !enabled)
		return;

	// create array of available audio tracknumbers

	track_bools = (unsigned char *) malloc(maxTrack * sizeof(unsigned char));

	if (track_bools == 0)
	    return;

	for (; i < maxTrack; i++)
	{
		entry.cdte_track = remap[i];
		entry.cdte_format = CDROM_MSF;
		if ( ioctl(cdfile, CDROMREADTOCENTRY, &entry) == -1 )
		{
			track_bools[i] = 0;
		}
		else 
			track_bools[i] = (entry.cdte_ctrl != CDROM_DATA_TRACK);

		free_tracks += track_bools[i];
	}

	if (!free_tracks)
	{
		Com_DPrintf("CDAudio_RandomPlay: Unable to find and play a random audio track, insert an audio cd please");
		goto free_end;
	}

	// choose random audio track
	do
	{
		do
		{
			f = ((float)rand()) / ((float)RAND_MAX + 1.0);
			track = (int)(maxTrack  * f);
		}
		while(!track_bools[track]);

		remap_track = remap[track];

		if (playing)
		{
			if (playTrack == remap_track)
			    goto free_end;
			CDAudio_Stop();
		}

		ti.cdti_trk0 = remap_track;
		ti.cdti_trk1 = remap_track;
		ti.cdti_ind0 = 1;
		ti.cdti_ind1 = 99;

		if ( ioctl(cdfile, CDROMPLAYTRKIND, &ti) == -1 ) 
		{
			track_bools[track] = 0;
			free_tracks--;
		}
		else
		{
			playLooping = true;
			playTrack = remap_track;
			playing = true;
			break;
		}
	}
	while (free_tracks > 0);

 free_end:
	free(track_bools);
}
#else /* let the others compile at least */
void CDAudio_RandomPlay(void) {
	Com_DPrintf("CDAudio_RandomPlay: Not yet supported on your platform");
}
#endif

void CDAudio_Stop(void)
{
	if (cdfile == -1 || !enabled)
		return;
	
	if (!playing)
		return;

/* merged in from cd_bsd.c -- jaq */
#ifdef __linux__
	if ( ioctl(cdfile, CDROMSTOP) == -1 )
		Com_DPrintf("ioctl cdromstop failed (%d:%s)\n", errno, strerror(errno));
#else /* bsd */
	if (ioctl(cdfile, CDIOCSTOP) == -1)
		Com_DPrintf("ioctl cdiocstop failed (%d:%s)\n", errno, strerror(errno));
#endif

	wasPlaying = false;
	playing = false;
}

void CDAudio_Pause(void)
{
	if (cdfile == -1 || !enabled)
		return;

	if (!playing)
		return;

/* merged in from cd_bsd.c -- jaq */
#ifdef __linux__
	if ( ioctl(cdfile, CDROMPAUSE) == -1 ) 
		Com_DPrintf("ioctl cdrompause failed\n");
#else /* bsd */
	if (ioctl(cdfile, CDIOCPAUSE) == -1)
		Com_DPrintf("ioctl cdiocpause failed\n");
#endif

	wasPlaying = playing;
	playing = false;
}


void CDAudio_Resume(void)
{
	if (cdfile == -1 || !enabled)
		return;
	
	if (!cdValid)
		return;

	if (!wasPlaying)
		return;
/* merged in from cd_bsd.c -- jaq */
#ifdef __linux__
	if ( ioctl(cdfile, CDROMRESUME) == -1 ) 
		Com_DPrintf("ioctl cdromresume failed\n");
#else /* bsd */
	if (ioctl(cdfile, CDIOCRESUME) == -1)
		Com_DPrintf("ioctl cdiocresume failed\n");
#endif
	playing = true;
}

static void CD_f (void)
{
	char	*command;
	int		ret;
	int		n;

	if (Cmd_Argc() < 2)
		return;

	command = Cmd_Argv (1);

	if (Q_strcasecmp(command, "on") == 0)
	{
		enabled = true;
		return;
	}

	if (Q_strcasecmp(command, "off") == 0)
	{
		if (playing)
			CDAudio_Stop();
		enabled = false;
		return;
	}

	if (Q_strcasecmp(command, "reset") == 0)
	{
		enabled = true;
		if (playing)
			CDAudio_Stop();
		for (n = 0; n < 100; n++)
			remap[n] = n;
		CDAudio_GetAudioDiskInfo();
		return;
	}

	if (Q_strcasecmp(command, "remap") == 0)
	{
		ret = Cmd_Argc() - 2;
		if (ret <= 0)
		{
			for (n = 1; n < 100; n++)
				if (remap[n] != n)
					Com_Printf("  %u -> %u\n", n, remap[n]);
			return;
		}
		for (n = 1; n <= ret; n++)
			remap[n] = atoi(Cmd_Argv (n+1));
		return;
	}

	if (Q_strcasecmp(command, "close") == 0)
	{
		CDAudio_CloseDoor();
		return;
	}

	if (!cdValid)
	{
		CDAudio_GetAudioDiskInfo();
		if (!cdValid)
		{
			Com_Printf("No CD in player.\n");
			return;
		}
	}

	if (Q_strcasecmp(command, "play") == 0)
	{
		CDAudio_Play((byte)atoi(Cmd_Argv (2)), false);
		return;
	}

	if (Q_strcasecmp(command, "loop") == 0)
	{
		CDAudio_Play((byte)atoi(Cmd_Argv (2)), true);
		return;
	}

	if (Q_strcasecmp(command, "stop") == 0)
	{
		CDAudio_Stop();
		return;
	}

	if (Q_strcasecmp(command, "pause") == 0)
	{
		CDAudio_Pause();
		return;
	}

	if (Q_strcasecmp(command, "resume") == 0)
	{
		CDAudio_Resume();
		return;
	}

	if (Q_strcasecmp(command, "eject") == 0)
	{
		if (playing)
			CDAudio_Stop();
		CDAudio_Eject();
		cdValid = false;
		return;
	}

	if (Q_strcasecmp(command, "info") == 0)
	{
		Com_Printf("%u tracks\n", maxTrack);
		if (playing)
			Com_Printf("Currently %s track %u\n", playLooping ? "looping" : "playing", playTrack);
		else if (wasPlaying)
			Com_Printf("Paused %s track %u\n", playLooping ? "looping" : "playing", playTrack);
		Com_Printf("Volume is %f\n", cdvolume);
		return;
	}
}

void CDAudio_Update(void)
{
/* merged in from cd_bsd.c -- jaq */
#ifdef __linux__
	struct cdrom_subchnl subchnl;
#else /* bsd */
	struct ioc_read_subchannel subchnl;
	struct cd_sub_channel_info subchnl_info;
#endif
	static time_t lastchk;

	if (cdfile == -1 || !enabled)
		return;

	if (cd_volume && cd_volume->value != cdvolume)
	{
		if (cdvolume)
		{
			Cvar_SetValue ("cd_volume", 0.0);
			cdvolume = cd_volume->value;
			CDAudio_Pause ();
		}
		else
		{
			Cvar_SetValue ("cd_volume", 1.0);
			cdvolume = cd_volume->value;
			CDAudio_Resume ();
		}
	}

	if (playing && lastchk < time(NULL)) {
		lastchk = time(NULL) + 2; //two seconds between chks
#ifdef __linux__
		subchnl.cdsc_format = CDROM_MSF;
		if (ioctl(cdfile, CDROMSUBCHNL, &subchnl) == -1 ) {
			Com_DPrintf("ioctl cdromsubchnl failed\n");
			playing = false;
			return;
		}
		
		if (subchnl.cdsc_audiostatus != CDROM_AUDIO_PLAY &&
			subchnl.cdsc_audiostatus != CDROM_AUDIO_PAUSED) {
			playing = false;
			if (playLooping)
				CDAudio_Play(playTrack, true);
		}
#else /* bsd */
		subchnl.address_format = CD_MSF_FORMAT;
		subchnl.data_len = sizeof(struct cd_sub_channel_info);
		subchnl.data = &subchnl_info;
		if (ioctl(cdfile, CDIOCREADSUBCHANNEL, &subchnl) == -1) {
			Com_DPrintf("ioctl cdiocreadsubchannel failed\n");
			playing = false;
			return;
		}
		
		if (subchnl_info.header.audio_status != CD_AS_PLAY_IN_PROGRESS &&
				subchnl_info.header.audio_status != CD_AS_PLAY_PAUSED) {
			playing = false;
			if (playLooping)
				CDAudio_Play(playTrack, true);
		}
#endif
	}
}

int CDAudio_Init(void)
{
	int i;
	cvar_t			*cv;
	extern uid_t saved_euid;

	if (initialized)
		return 0;

	cv = Cvar_Get ("nocdaudio", "0", CVAR_NOSET);
	if (cv->value)
		return -1;

	cd_nocd = Cvar_Get ("cd_nocd", "0", CVAR_ARCHIVE );
	if ( cd_nocd->value)
		return -1;

	cd_volume = Cvar_Get ("cd_volume", "1", CVAR_ARCHIVE);

/* merged in from cd_bsd.c -- jaq */
#ifdef __linux__
	cd_dev = Cvar_Get("cd_dev", "/dev/cdrom", CVAR_ARCHIVE);
#else /* bsd */
	cd_dev = Cvar_Get("cd_dev", "/dev/cd0c", CVAR_ARCHIVE);
#endif

	seteuid(saved_euid);

	cdfile = open(cd_dev->string, O_RDONLY);

	seteuid(getuid());

	if (cdfile == -1) {
		Com_Printf("CDAudio_Init: open of \"%s\" failed (%i)\n", cd_dev->string, errno);
		cdfile = -1;
		return -1;
	}

	for (i = 0; i < 100; i++)
		remap[i] = i;
	initialized = true;
	enabled = true;

	if (CDAudio_GetAudioDiskInfo())
	{
		Com_Printf("CDAudio_Init: No CD in player.\n");
		cdValid = false;
	}

	Cmd_AddCommand ("cd", CD_f);

	Com_Printf("CD Audio Initialized\n");

	return 0;
}

void CDAudio_Activate (qboolean active)
{
	if (active)
		CDAudio_Resume ();
	else
		CDAudio_Pause ();
}

void CDAudio_Shutdown(void)
{
	if (!initialized)
		return;
	CDAudio_Stop();
	close(cdfile);
	cdfile = -1;
	initialized = false;
}
