#!/usr/local/bin/ruby

require "honyaku"

user = ENV["USER"]
mode = ARGV.shift
query = STDIN.read

begin
  host = Honyaku.new(user, mode)
  host.trns_divide_sentence(query).each() do |sentence|
    print "\n\n" if sentence.is_paragraph?
    print " "    if mode == "JE" and sentence.is_follow?
    if sentence.is_need_trans?
      print host.translate_one(sentence)
    else
      print sentence
    end
  end
  host.close
rescue HonyakuError
  STDERR.print "Error(#{$!}) #{Honyaku::ERROR_MESSAGE[$!.to_s]}\n"
  host.close if host
rescue Errno::ECONNREFUSED
  STDERR.print "Error: transration server is not running."
end
