=begin
$Date: 1999/12/18 01:48:29 $

== ̾

honyaku.rb - ץ饤Ⱥѥ饤֥

Version 0.20

Wakou Aoyama <wakou@fsinet.or.jp>


== 

OMRON SOFTWARE Co., Ltd αեȡפΥ饤
ѥ饤֥Ǥפϡץȥڤӥ饤Ȥ lisp
ɤƱ졢Ƥޤ
http://www.omronsoft.co.jp/SP/pcunix/honyaku/index.html

Υ饤֥ϸ xhonyaku 뵡ǽ¸٤Υץȥ
󶡤Ƥޤ⤷ⵡǽʥ饤ȤȤ
ä㤤ޤ顢ϢƲ

ޤΥ饤֥ǤϡޤץȥͽˤϤ٤
λͤϵܤƤʤ褦ǡͽۤǽ񤤤Ƥޤޤ顼
åϵܤƤʤΤǡlisp ɤ䡢顼ȴ
ѤƤޤ


== ץ

	#!/usr/local/bin/ruby
	
	require "honyaku"
	
	user = ENV["USER"]
	mode = ARGV.shift
	query = STDIN.read
	
	begin
	  host = Honyaku.new(user, mode)
	  host.trns_divide_sentence(query).each() do |sentence|
	    print "\n", "[] ", sentence, "\n"
	    if sentence.is_need_trans?
	      print "[] ", host.translate_one(sentence), "\n"
	    else
	      print "[] ", sentence, "\n"
	    end
	  end
	  host.close
	rescue HonyakuError
	  STDERR.print "Error(#{$!}) #{Honyaku::ERROR_MESSAGE[$!.to_s]}\n"
	  host.close if host
	rescue Errno::ECONNREFUSED
	  STDERR.print "Error: transration server is not running."
	end

 honyaku Ȥե¸硢Τ褦ʥ󥿡ե
Υ饤Ȥˤʤޤ

	$ honyaku ej
	Hello.

	[] Hello.
	[] ˤϡ


== 饹

=== ERROR_MESSAGE
顼å Hashϥ顼ֹ String ˤΡ
=end

class HonyakuError < StandardError
end

class Honyaku
  require 'socket'

v = $-v
$-v = false
  VERSION = "0.20"
  RELEASE_DATE = "$Date: 1999/12/18 01:48:29 $"
$-v = v

=begin
== 饹᥽å
=== new(user, mode, server = 'localhost', port = Honyaku::SERVER_PORT)
mode  "ej"  "je" Ǥ

=== int_to_str(i)
int  4 byte string Ѵ
=end
  def int_to_str(i)
    raise "out of range" unless - 2 ** (32 - 1) <= i and i < 2 ** (32 - 1)
    i += 2 ** 32 if i < 0
    ( i                >> 24).chr +
    ((i & ~0xff000000) >> 16).chr +
    ((i & ~0xffff0000) >>  8).chr +
    ( i & ~0xffffff00       ).chr
  end

=begin
=== short_to_str(i)
short  2 byte string Ѵ
=end
  def short_to_str(i)
    raise "out of range" unless - 2 ** (16 - 1) <= i and i < 2 ** (16 - 1)
    i += 2 ** 16 if i < 0
    ((i & ~0xffff0000) >> 8).chr +
    ( i & ~0xffffff00      ).chr
  end

=begin
=== str_to_int(str)
4 byte string  int Ѵ
=end
  def str_to_int(str)
    i = (str[0]<<24) + (str[1]<<16) + (str[2]<<8) + str[3]
    if 2 ** (32 - 1) <= i
      i - 2 ** 32 
    else
      i
    end
  end

=begin
=== str_to_int(str)
2 byte string  short Ѵ
=end
  def str_to_short(str)
    i = (str[0]<<8) + str[1]
    if 2 ** (16 - 1) <= i
      i - 2 ** 16
    else
      i
    end
  end

  module_function :int_to_str, :short_to_str, :str_to_int, :str_to_short

  HEAD                 = "\xaa\xbb\xcc\xdd"
  PROTOCOL_VERSION     = int_to_str(0xe001)    # ץȥС
  EG_INIT              = int_to_str(0xf00001)  # ѳ
  EG_END               = int_to_str(0xf00002)  # ѽλ
  EG_TRANSLATE_ONE     = int_to_str(0xf00004)  # ʸ
  EG_BROWSE_DICT       = int_to_str(0xf00015)  # 񻲾
  EG_GETEQUIV          = int_to_str(0xf00007)  # б
  EG_GETWORD           = int_to_str(0xf00008)  # ꥹȤμ
  EG_SETWORD           = int_to_str(0xf00009)  # ѹ
  EG_GETHINSHI         = int_to_str(0xf0000a)  # ʻꥹȤμ
  EG_SETHINSHI         = int_to_str(0xf0000b)  # ʻѹ
  EG_GETTRNTXT         = int_to_str(0xf0000c)  # ʸ֤
  EG_SETLEARN          = int_to_str(0xf0000e)  # ؽ
  EG_SETMODE           = int_to_str(0xf00011)  # ⡼ɤΥå
  EG_SETDICTNAME       = int_to_str(0xf00013)  # Ѽ
  EG_CLEAR_CACHE       = int_to_str(0xf00014)  # 񥭥åΥꥢ
  TRNS_GET_STATUS      = int_to_str(0xf0001a)  # СΥơ
  TRNS_DIVIDE_SENTENCE = int_to_str(0xf0001b)  # ʸʬ
  EG_SET_TIMEOUT       = int_to_str(0xf0001c)  # ॢȤ
  EJ                   = int_to_str(1)
  JE                   = int_to_str(2)
  SERVER_PORT          = 2744    # ǥեȥХݡ
  LOCK_WAITTIME        = 30      # ǥեȼեåॢ
  TRANS_WAITTIME       = 30      # ǥեॢ

  ERROR_MESSAGE = Hash[ %w[
     -114  EOF_or_Error_on_socket_to_client
     -126  First_command_is_not_init
     -137  Not_initialized_for_ej
     -139  Not_initialized_for_je
     -141  Already_initialized_for_ej
     -143  Already_initialized_for_je
     -202  Unknown_command
     -206  ʸޤʸĹޤʸûڤäƺƤ
     -300  Ф³ǤޤǤ
     -500  ɥΥ᤮ޤ
     -501  ФȤ̿̿Ū顼ȯޤ
     -502  ꤵ줿֤ˤñ줬¸ߤޤ
     -503  䤬ޤ
     -600  饤󥹤ǤޤǤ
    -1003  ʸϤ˼ԤޤʸƺƤ
    -1012  ʸΤΰ֤ˤñ줬¸ߤޤ
    -3000  ǻ֤᤮ƥॢȤȯޤ
    -3004  Ʊ桼γؽΥåǥॢȤȯޤ
    -4000  ʸޤʸĹޤʸûڤäƺƤ
    -4002  ̤ޤѸ켭ǧƤ
    -4003  ̤ޤѸ켭ǧƤ
    -4004  ޤƤޤ
    -4016  ˻ꤷñ줬ޤ
    -4017  ɤ߹ߤǤޤǤ
  ]]

=begin
== ᥽å

=== request_send(request, trans_waittime = Honyaku::TRANS_WAITTIME)
ꥯȤ֤(String)ϥСΥ쥹ݥ󥹡
=end
  def request_send(request, trans_waittime = TRANS_WAITTIME)
    IO::select(nil, [@host])
    @host.syswrite(HEAD + int_to_str(request.length) + request)

    IO::select([@host], nil, nil, trans_waittime)
    status = @host.read(4)                  # إåǧ
    unless status == HEAD
      raise HonyakuError, status.to_s
    end
    length = str_to_int(@host.read(4))      # 쥹ݥĹ
    status = str_to_int(@host.read(4))      # ơǧ
    unless status == 0
      raise HonyakuError, status.to_s
    end
    @host.read(length - 4)                  # 쥹ݥ󥹼
  end

  module_function :request_send

=begin
=== trns_get_status()
СΥơ
=end
  def trns_get_status()
    request_send(TRNS_GET_STATUS + int_to_str(1))
  end

=begin
=== init(honyaku_version = Honyaku::PROTOCOL_VERSION)
ѳϡ
=end
  def init(honyaku_version = PROTOCOL_VERSION)
    request_send(EG_INIT + @mode + honyaku_version + @user + "\000")
  end

=begin
=== setmode(setmode = nil)
⡼ɤΥåȡ
=end
  def setmode(setmode = nil)
    if @mode == EJ
      setmode = "KW"
      request_send(EG_SETMODE + EJ + setmode + "\000")
    end
  end

=begin
=== set_timeout(lock_waittime = Honyaku::LOCK_WAITTIME, trans_waittime = Honyaku::TRANS_WAITTIME)
ॢȤꡣ
=end
  def set_timeout(lock_waittime = LOCK_WAITTIME,
                     trans_waittime = TRANS_WAITTIME)
    request_send(EG_SET_TIMEOUT + @mode +
      int_to_str(lock_waittime) + int_to_str(trans_waittime))
  end

=begin
=== setdictname(computer_dict_use = 1, dict_learning = 1)
Ѽꡣ֤(String)ϼμ̡
+ computer_dict_use: ԥ塼缭(Ի:0)
+ dict_learning: ؽ(Ի:0)
=end
  def setdictname(computer_dict_use = 1, dict_learning = 1)
    request_send(EG_SETDICTNAME + @mode +
      int_to_str(computer_dict_use) +  # ԥ塼缭(Ի:0)
      int_to_str(dict_learning) +      # ؽ(Ի:0)
      int_to_str(3) +                  # ؽο
      short_to_str(3) +                # Ѹ켭
      "C" +                            # ID
      "Ccomputer\000" +                # ̾
      short_to_str(0) +                # ƥ༭
      "S" +                            # ID
      "Sdummy\000" +                   # ̾
      short_to_str(4) +                # ؽ
      "L" +                            # ID
      "L" + @user + "\000")            # ̾
  end

  module Sentence
    def is_need_trans?
      true
    end
    def is_normal_text?
      false
    end
    def is_title?
      false
    end
    def is_list?
      false
    end

    def is_paragraph?
      false
    end
    def is_follow?
      false
    end
    def is_prepared?
      false
    end
  end

=begin
=== trns_divide_sentence(string, option = 1)
ʸʬ䡣֤(String ޤ Array)ϡʸʬ䤵줿
+ option: ʸղ(ղäʤ:0)

Τ褦ˡʸФƤޤ

	host.trns_divide_sentence("string").each() do |sentence|
	  host.translate_one(sentence)
	end

Ф줿 sentence ˤϡðۥ᥽åɤƤޤ

+ 裱
is_need_trans?, is_normal_text?, is_title?, is_list? ΣĤɤ줫

++ is_need_trans?
ɬפ뤫ɤ

++ is_normal_text?
̾ʸ

++ is_title?
ȥʸ(ʸʤʸʤ)

++ is_list?
վʸ

+ 裲
is_paragraph?, is_follow?, is_prepared? ΣĤɤ줫

++ is_paragraph?
λϤޤʸ

++ is_follow?
Σʸܰʹߤʸ

++ is_prepared?
ơ֥Τ褦ƤơʸȤϥ֤ʤɤǶڤ줿ʸ

=end
  def trns_divide_sentence(string, option = 1)
    response = request_send(TRNS_DIVIDE_SENTENCE + @mode +
                 int_to_str(option) + # ʸղ(ղäʤ:0)
                 string + "\000").chop!.chomp!
    response[0,4] = ''                 # ʬ䤷ʸο (Ȥꤢ˴)
    p response if $DEBUG
    response = response.split("\n").filter() do |p|
      sentence = p[2..-1]
      sentence.extend(Sentence)

      case p[0].chr
      when / /
        def sentence.is_normal_text?
          true
        end
      when /L/
        def sentence.is_list?
          true
        end
      when /T/
        def sentence.is_title?
          true
        end
      when /[tli]/
        def sentence.is_need_trans?
          false
        end
      end

      case p[1].chr
      when /P/
        def sentence.is_paragraph?
          true
        end
      when / /
        def sentence.is_follow?
          true
        end
      when /S/
        def sentence.is_prepared?
          true
        end
      end
      sentence
    end
  end

=begin
=== translate_one(sentence)
ʸ֤(String)ʸ
=end
  def translate_one(sentence)
    response = request_send(EG_TRANSLATE_ONE + @mode +
      int_to_str(0) +    # «
      int_to_str(4096) + # ʸѥХåե
      short_to_str(0) +    # «
      short_to_str(0) +    # «
      int_to_str(0) +    # «
      sentence + "\000").chop!
    response[0,2] = ''
    response
  end

=begin
=== close()
ѽλ
=end
  def close()
    unless @host.closed?
      for mode in @use_mode
        request_send(EG_END + mode)
      end
      @host.close
    end
  end

=begin
=== clear_cache()
񥭥åΥꥢ
=end
  def clear_cache()
    request_send(EG_CLEAR_CACHE + @mode)
  end

=begin
=== user
ߤΥ桼̾

=== mode
ߤμΥ⡼ɡ
=end
  attr_reader("user", "mode")

=begin
=== user = "user"
桼̾ꡣ
=end
  def user=(user)
    @user = user
    mode_init()
  end

=begin
=== mode = "mode"
Υ⡼ɤꡣ
+ "mode"  "ej"  "je"
=end
  def mode=(mode)
    @mode = mode.upcase == "EJ" ? Honyaku::EJ : Honyaku::JE
    mode_init()
  end

  def mode_init()
    unless @use_mode.include?(@mode)
      @use_mode.push(@mode.dup)
      init()       # ѳ
    end
    setdictname()  # Ѽ
    set_timeout()  # ॢȤ
    setmode()      # ⡼ɤΥå
    clear_cache()  # 񥭥åΥꥢ
  end

  def initialize(user, mode, server = '0', port = SERVER_PORT)
    @user = user
    @mode = mode.upcase == "EJ" ? Honyaku::EJ : Honyaku::JE
    @use_mode = []
    @host = TCPSocket.open(server, port)
    @host.sync = true
    mode_init()
  end
end

=begin

== HISTORY

=== Version 0.20

1999/12/18

- OMRON ץȥͽνλǤϤΤǡ碌ƽ

=== Version 0.10

1999/12/8

- Хơˤ㳰ȯ(ªѥå)ɲá

=== Version 0.01

1999/11/29

- 饤֥경

=== Version --

1999/11/28

- ޥɥ饤ǥ饤Ⱥ

=end
