#ifndef __TOOLBAR__H_
#define __TOOLBAR__H_

enum {
    SMART_TOOLBAR_BUTTON,
    SMART_COLUMN_BUTTON,
    SMART_BUTTON_TYPES
};

typedef struct toggle_button_init_t {
    gchar *tag;
    gchar *name;
    gpointer callback;
    gpointer data;
} toggle_button_init_t;


typedef struct smart_button_init_t {
    gchar *image;
    gchar *tooltip;
    void (*callback) (GtkWidget *widget); /* callback used by internal buttons */
    gchar *name;
    /* XXX should use union here... */
    gchar *cmd; /* used by panel elements */
    gchar *caption;/* used by panel elements */
    void *menu_callback;/*  used by menu elements */
    guint key;
} smart_button_init_t;


typedef struct smart_button_t {
    int id;
    GtkWidget *altimage;
    gchar *tooltip;
    gchar *cmd;
    void (*callback) (GtkWidget *widget);
    GtkWidget *widget;
    gpointer smartp;
}smart_button_t;

typedef struct smart_t {
    gchar *cmd;
    gchar *name;
    gchar *tooltip;
    smart_button_t *smart_button;
    GtkWidget *menu;
    GtkWidget *button;
    GtkWidget *image;
    GtkWidget *widget;
    void (*callback) (GtkWidget *widget);
    int type;
    gpointer button_info;
}smart_t;

void toolbar_buttons(void);

int parse_panel_config(void);

/*funky:*/
smart_t *
mk_smart_button(	smart_button_init_t *button_info,
			gchar *name,
			GtkWidget **button_p);
void sb_show_size(GtkWidget *w);
void sb_show_date(GtkWidget *w);
void sb_show_owner(GtkWidget *w);
void sb_show_group(GtkWidget *w);
void sb_show_mode(GtkWidget *w);
void sb_toggle_win(GtkWidget *w);
void sb_toggle_smb(GtkWidget *w);
void sb_toggle_fstab(GtkWidget *w);
void sb_toggle_book(GtkWidget *w);
void sb_toggle_trash(GtkWidget *w);
void sb_toggle_recent(GtkWidget *w);
void sb_toggle_frequent(GtkWidget *w);

void smart_menus(void);


#endif

