unit AdminCatalogTableCheck;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Progress, MySQLConnection,
  myx_public_interface, myx_admin_public_interface, ExtCtrls, ComCtrls,
  ApplicationDataModule, AuxFuncs, TntForms, TntComCtrls, TntStdCtrls,
  TntExtCtrls, TntClasses, gnugettext;

type
  TableAction = (taOptimize=1, taCheck=2, taRepair=3);

  TAdminCatalogTableCheckForm = class(TTntForm)
    PageControl: TTntPageControl;
    OptionsTabSheet: TTabSheet;
    GroupBox1: TTntGroupBox;
    QuickRBtn: TTntRadioButton;
    FastRBtn: TTntRadioButton;
    MediumRBtn: TTntRadioButton;
    ExtendedRBtn: TTntRadioButton;
    ChangedRBtn: TTntRadioButton;
    ResultTabSheet: TTabSheet;
    PageControlHidePnl: TTntPanel;
    Label1: TTntLabel;
    Label2: TTntLabel;
    ResultMemo: TTntMemo;
    Label3: TTntLabel;
    HeaderLbl: TTntLabel;
    Label4: TTntLabel;
    OptimizeTabSheet: TTabSheet;
    Label5: TTntLabel;
    Label6: TTntLabel;
    GroupBox2: TTntGroupBox;
    OptLocalCBox: TTntCheckBox;
    Label7: TTntLabel;
    Label8: TTntLabel;
    Label9: TTntLabel;
    Label10: TTntLabel;
    Label11: TTntLabel;
    RepairTabSheet: TTabSheet;
    Label12: TTntLabel;
    Label13: TTntLabel;
    GroupBox3: TTntGroupBox;
    GroupBox4: TTntGroupBox;
    Label14: TTntLabel;
    Label17: TTntLabel;
    RepExtendedCBox: TTntCheckBox;
    RepQuickCBox: TTntCheckBox;
    RepUseFRMCBox: TTntCheckBox;
    Label15: TTntLabel;
    OptLocalLbl: TTntLabel;
    RepLocalCBox: TTntCheckBox;
    Label18: TTntLabel;
    RepairWarning: TTntLabel;
    Panel1: TTntPanel;
    ExecuteTableActionBtn: TTntButton;
    CloseBtn: TTntButton;
    Label19: TTntLabel;
    Label20: TTntLabel;
    SelectTabSheet: TTabSheet;
    Label21: TTntLabel;
    Label22: TTntLabel;
    GroupBox5: TTntGroupBox;
    Label23: TTntLabel;
    OptimizeTablesRBtn: TTntRadioButton;
    CheckTablesRBtn: TTntRadioButton;
    Label24: TTntLabel;
    Label25: TTntLabel;
    RepairCheckTablesRBtn: TTntRadioButton;
    GroupBox6: TTntGroupBox;
    TableListBox: TTntListBox;
    Label26: TTntLabel;

    constructor Create(AOwner: TComponent; Tables: WideString;
      MySQLConn: TMySQLConn;
      Action: TableAction = taOptimize); reintroduce;

    procedure ExecuteTableActionBtnClick(Sender: TObject);
    procedure CloseBtnClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);

    procedure ExecuteTableAction(Sender: TObject);
    procedure FinishedTableAction(Sender: TObject);
    procedure UpdateProgressForm(Sender: TObject);
  private
    { Private declarations }
    TableList: TTntStringList;
    MySQLConn: TMySQLConn;

    ProgressForm: TProgressForm;
  public
    { Public declarations }
    CheckType: integer;
    Messages: WideString;
    CurrentPos: integer;
    CurrentTable: WideString;
    Action: TableAction;
  end;

var
  AdminCatalogTableCheckForm: TAdminCatalogTableCheckForm;

implementation

uses AdminCatalog;

{$R *.dfm}

constructor TAdminCatalogTableCheckForm.Create(AOwner: TComponent;
  Tables: WideString;
  MySQLConn: TMySQLConn;
  Action: TableAction);
begin
  inherited Create(AOwner);

  InitForm(self);

  TableList:=TTntStringList.Create;
  TableList.Text:=Tables;

  self.MySQLConn:=MySQLConn;
  self.Action:=Action;

  TableListBox.Items.Text:=Tables;

  OptLocalCBox.Enabled:=
    ((MySQLConn.MySQLMajorVersion=4)and
      (MySQLConn.MySQLMinorVersion>=1))or
    (MySQLConn.MySQLMajorVersion>4);
  OptLocalLbl.Enabled:=OptLocalCBox.Enabled;
end;

procedure TAdminCatalogTableCheckForm.FormCreate(Sender: TObject);
begin
  PageControl.ActivePageIndex:=0;
  PageControlHidePnl.BringToFront;

  case Action of
    taOptimize:
      OptimizeTablesRBtn.Checked:=True;
    taCheck:
      CheckTablesRBtn.Checked:=True;
    taRepair:
      RepairCheckTablesRBtn.Checked:=True;
  end;
end;

procedure TAdminCatalogTableCheckForm.FormDestroy(Sender: TObject);
begin
  TableList.Free;

  TAdminCatalogForm(Owner).AdminCatalogTableCheckForm:=nil;
end;

procedure TAdminCatalogTableCheckForm.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  Action:=caFree;
end;

procedure TAdminCatalogTableCheckForm.ExecuteTableAction(Sender: TObject);
var i, j: integer;
  PMySQL: Pointer;
  PStatuses: PMYX_TABLE_COMMAND_STATUSES;
  Statuses: TMYX_TABLE_COMMAND_STATUSES;
  ErrorString, SuccessString: WideString;
begin
  with TAdminCatalogTableCheckForm(TFetchDataThread(Sender).Target) do
  begin
    case Action of
      taOptimize:
      begin
        ErrorString:=_('Error - Table %s could not be optimized.');
        SuccessString:=_('Table %s optimized.');
      end;
      taCheck:
      begin
        ErrorString:=_('Error - Table %s could not be checked.');
        SuccessString:=_('Status checked for table %s.');
      end;
    else
      ErrorString:=_('Error - Table %s could not be repaired.');
      SuccessString:=_('Table %s repaired.');
    end;

    PMySQL:=myx_mysql_init;
    try
      myx_connect_to_instance(MySQLConn.user_connection.get_record_pointer, PMySQL);

      for i:=0 to TableList.Count-1 do
      begin
        CurrentPos:=i;
        CurrentTable:=TableList[i];

        TFetchDataThread(Sender).ExecuteSynchronized(
          UpdateProgressForm);

        case Action of
          taOptimize:
            PStatuses:=myx_optimize_table(PMySQL,
              TableList[i], CheckType);
          taCheck:
            PStatuses:=myx_check_table(PMySQL,
              TableList[i], CheckType);
        else
          PStatuses:=myx_repair_table(PMySQL,
            TableList[i], CheckType);
        end;


        if(PStatuses=nil)then
        begin
          Messages:=Messages+StringOfChar('-', 120)+#13#10;

          Messages:=Messages+
            Format(ErrorString, [TableList[i]])+#13#10+
            _('MySQL Error Nr.')+IntToStr(myx_mysql_errno(PMySQL))+#13#10+
            myx_mysql_error(PMySQL)+#13#10;
        end
        else
        begin
          try
            Statuses:=TMYX_TABLE_COMMAND_STATUSES.Create(PStatuses);
            try
              for j:=0 to Statuses.status.Count-1 do
              begin
                Messages:=Messages+StringOfChar('-', 120)+#13#10;
                Messages:=Messages+Format(SuccessString, [Statuses.status[j].table])+#13#10;
                Messages:=Messages+Statuses.status[j].message+#13#10;
              end;
            finally
              Statuses.Free;
            end;
          finally
            myx_free_command_status(PStatuses);
          end;
        end;

        if(ProgressForm.Stopping)then
          break;
      end;

      ProgressForm.Advance(TableList.Count, False);
      ProgressForm.Refresh;
    finally
      myx_mysql_close(PMySQL);
    end;
  end;
end;

procedure TAdminCatalogTableCheckForm.FinishedTableAction(Sender: TObject);
begin
  with TAdminCatalogTableCheckForm(TFetchDataThread(Sender).Target) do
  begin
    ProgressForm.Free;

    ResultMemo.Text:=Messages;

    PageControl.ActivePage:=ResultTabSheet;
    ExecuteTableActionBtn.Hide;
    
    Height:=463;
    Show;
  end;
end;

procedure TAdminCatalogTableCheckForm.UpdateProgressForm(Sender: TObject);

begin
  ProgressForm.ActionLbl.Caption:=CurrentTable;
  ProgressForm.Advance(CurrentPos, False);
end;


procedure TAdminCatalogTableCheckForm.ExecuteTableActionBtnClick(Sender: TObject);
begin
  if(PageControl.ActivePageIndex=0)then
  begin
    if(OptimizeTablesRBtn.Checked)then
      Action:=taOptimize
    else if(CheckTablesRBtn.Checked)then
      Action:=taCheck
    else
      Action:=taRepair;

    case Action of
      taOptimize:
      begin
        Caption:=_('Optimize Tables');
        ExecuteTableActionBtn.Caption:=_('Optimize Tables');

        Height:=204;
      end;
      taCheck:
      begin
        Caption:=_('Check Tables');
        ExecuteTableActionBtn.Caption:=_('Check Tables');

        Height:=360;
      end;
      taRepair:
      begin
        Caption:=_('Repair Tables');
        ExecuteTableActionBtn.Caption:=_('Repair Tables');

        Height:=515;
      end;
    end;

    PageControl.ActivePageIndex:=Ord(Action);
  end
  else
  begin
    Hide;

    CheckType:=0;
    if(Action=taOptimize)then
    begin
      if(OptLocalCBox.Checked)then
        CheckType:=Ord(MYX_REPAIR_NO_WRITE_TO_BINLOG);
    end
    else if(Action=taCheck)then
    begin
      if(QuickRBtn.Checked)then
        CheckType:=Ord(MYX_CHECK_QUICK)
      else if(FastRBtn.Checked)then
        CheckType:=Ord(MYX_CHECK_FAST)
      else if(MediumRBtn.Checked)then
        CheckType:=Ord(MYX_CHECK_MEDIUM)
      else if(ExtendedRBtn.Checked)then
        CheckType:=Ord(MYX_CHECK_EXTENDED)
      else if(ChangedRBtn.Checked)then
        CheckType:=Ord(MYX_CHECK_CHANGED)
      else
        CheckType:=Ord(MYX_CHECK_MEDIUM);
    end
    else if(Action=taCheck)then
    begin
      if(RepLocalCBox.Checked)then
        CheckType:=CheckType+Ord(MYX_REPAIR_NO_WRITE_TO_BINLOG);

      if(RepQuickCBox.Checked)then
        CheckType:=CheckType+Ord(MYX_CHECK_QUICK);

      if(RepExtendedCBox.Checked)then
        CheckType:=CheckType+Ord(MYX_CHECK_EXTENDED);

      if(RepUseFRMCBox.Checked)then
        CheckType:=CheckType+Ord(MYX_REPAIR_USE_FRM);
    end;

    Messages:='';
    CurrentTable:='';
    CurrentPos:=0;

    ProgressForm:=TProgressForm.Create(nil);
    try
      case Action of
        taOptimize:
        begin
          ProgressForm.Caption:=_('Optimize Table Progress ...');
          ProgressForm.ActionCaptionLbl.Caption:=_('Optimize Table:');
        end;
        taCheck:
        begin
          ProgressForm.Caption:=_('Check Table Progress ...');
          ProgressForm.ActionCaptionLbl.Caption:=_('Check Table:');
        end;
      else
        ProgressForm.Caption:=_('Repair Table Progress ...');
        ProgressForm.ActionCaptionLbl.Caption:=_('Repair Table:');
      end;

      ProgressForm.Reset;
      ProgressForm.Max := TableList.Count;

      ProgressForm.Show;

      MySQLConn.FetchData(KindOfData_TableAction,
        ExecuteTableAction, FinishedTableAction,
        self,_('Checking tables ...'), True);
    except
      ProgressForm.Free;
    end;
  end;
end;

procedure TAdminCatalogTableCheckForm.CloseBtnClick(Sender: TObject);
begin
  Close;
end;

end.
