/*
 * Decompiled with CFR 0.152.
 */
package com.gallery.GalleryRemote.prefs;

import com.gallery.GalleryRemote.Base64;
import com.gallery.GalleryRemote.Log;
import com.gallery.GalleryRemote.prefs.PreferenceNames;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;

public class GalleryProperties
extends Properties
implements PreferenceNames {
    public static final String MODULE = "GalProps";
    SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd");
    protected Dimension thumbnailSize = null;
    protected Rectangle mainBounds = null;
    protected Rectangle previewBounds = null;
    private static final String keyValueSeparators = "=: \t\r\n\f";
    private static final String strictKeyValueSeparators = "=:";
    private static final String whiteSpaceChars = " \t\r\n\f";

    public GalleryProperties(Properties p) {
        super(p);
    }

    public GalleryProperties() {
    }

    public String getProperty(String key) {
        return this.getProperty(key, false);
    }

    public String getProperty(String key, boolean emptySignificant) {
        String value;
        Object oval = super.get(key);
        String sval = oval instanceof String ? (String)oval : null;
        String string = value = (sval == null || sval.length() == 0 && !emptySignificant) && this.defaults != null ? this.defaults.getProperty(key) : sval;
        if (value == null || value.length() == 0 && !emptySignificant) {
            return null;
        }
        return value;
    }

    public void copyProperties(Properties source) {
        Enumeration<?> names = source.propertyNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            String value = source.getProperty(name);
            String currentValue = this.getProperty(name);
            if (currentValue != null && currentValue.length() != 0 && (value == null || value.length() == 0)) continue;
            super.setProperty(name, value);
        }
    }

    public void load(String data) throws IOException {
        BufferedReader in = new BufferedReader(new StringReader(data));
        String line;
        while ((line = in.readLine()) != null) {
            int valueIndex;
            int separatorIndex;
            int keyStart;
            char firstChar;
            if (line.length() <= 0 || (firstChar = line.charAt(0)) == '#' || firstChar == '!') continue;
            int len = line.length();
            for (keyStart = 0; keyStart < len && whiteSpaceChars.indexOf(line.charAt(keyStart)) != -1; ++keyStart) {
            }
            if (keyStart == len) continue;
            for (separatorIndex = keyStart; separatorIndex < len; ++separatorIndex) {
                char currentChar = line.charAt(separatorIndex);
                if (currentChar == '\\') {
                    ++separatorIndex;
                    continue;
                }
                if (keyValueSeparators.indexOf(currentChar) != -1) break;
            }
            for (valueIndex = separatorIndex; valueIndex < len && whiteSpaceChars.indexOf(line.charAt(valueIndex)) != -1; ++valueIndex) {
            }
            if (valueIndex < len && strictKeyValueSeparators.indexOf(line.charAt(valueIndex)) != -1) {
                ++valueIndex;
            }
            while (valueIndex < len && whiteSpaceChars.indexOf(line.charAt(valueIndex)) != -1) {
                ++valueIndex;
            }
            String key = line.substring(keyStart, separatorIndex);
            String value = separatorIndex < len ? line.substring(valueIndex, len) : "";
            this.put(this.loadConvert(key), this.loadConvert(value));
        }
        return;
    }

    public String loadConvert(String theString) {
        int len = theString.length();
        StringBuffer outBuffer = new StringBuffer(len);
        int x = 0;
        while (x < len) {
            int aChar;
            if ((aChar = theString.charAt(x++)) == 92) {
                if ((aChar = theString.charAt(x++)) == 117) {
                    int value = 0;
                    block6: for (int i = 0; i < 4; ++i) {
                        aChar = theString.charAt(x++);
                        switch (aChar) {
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: {
                                value = (value << 4) + aChar - 48;
                                continue block6;
                            }
                            case 97: 
                            case 98: 
                            case 99: 
                            case 100: 
                            case 101: 
                            case 102: {
                                value = (value << 4) + 10 + aChar - 97;
                                continue block6;
                            }
                            case 65: 
                            case 66: 
                            case 67: 
                            case 68: 
                            case 69: 
                            case 70: {
                                value = (value << 4) + 10 + aChar - 65;
                                continue block6;
                            }
                            default: {
                                throw new IllegalArgumentException("Malformed \\uxxxx encoding.");
                            }
                        }
                    }
                    outBuffer.append((char)value);
                    continue;
                }
                if (aChar == 116) {
                    aChar = 9;
                } else if (aChar == 114) {
                    aChar = 13;
                } else if (aChar == 110) {
                    aChar = 10;
                } else if (aChar == 102) {
                    aChar = 12;
                }
                outBuffer.append((char)aChar);
                continue;
            }
            outBuffer.append((char)aChar);
        }
        return outBuffer.toString();
    }

    public File getCurrentDirectory() {
        String currentDirectory = this.getProperty("filedialogPath");
        if (currentDirectory != null) {
            return new File(currentDirectory);
        }
        return null;
    }

    public void setCurrentDirectory(File currentDirectory) {
        this.setProperty("filedialogPath", currentDirectory.getPath());
    }

    public boolean getShowPreview() {
        return this.getBooleanProperty("showPreview");
    }

    public void setShowPreview(boolean showPreview) {
        this.setProperty("showPreview", String.valueOf(showPreview));
    }

    public boolean getShowPath() {
        return this.getBooleanProperty("showPath");
    }

    public void setShowPath(boolean showPath) {
        this.setProperty("showPath", String.valueOf(showPath));
    }

    public boolean getShowThumbnails() {
        return this.getBooleanProperty("showThumbnails");
    }

    public void setShowThumbnails(boolean showThumbnails) {
        this.setProperty("showThumbnails", String.valueOf(showThumbnails));
    }

    public Dimension getThumbnailSize() {
        if (this.thumbnailSize == null) {
            this.thumbnailSize = this.getDimensionProperty("thumbnailSize");
        }
        return this.thumbnailSize;
    }

    public Rectangle getMainBounds() {
        if (this.mainBounds == null) {
            this.mainBounds = this.getRectangleProperty("mainBounds");
        }
        return this.mainBounds;
    }

    public Rectangle getPreviewBounds() {
        if (this.previewBounds == null) {
            this.previewBounds = this.getRectangleProperty("previewBounds");
        }
        return this.previewBounds;
    }

    public void setMainBounds(Rectangle r) {
        this.setRectangleProperty("mainBounds", r);
    }

    public void setPreviewBounds(Rectangle r) {
        this.setRectangleProperty("previewBounds", r);
    }

    public void setThumbnailSize(Dimension size) {
        this.thumbnailSize = size;
        this.setDimensionProperty("thumbnailSize", size);
    }

    public Dimension getDimensionProperty(String key) {
        StringTokenizer st;
        String value = this.getProperty(key);
        if (value == null) {
            return null;
        }
        if (value != null && (st = new StringTokenizer(value, ",")).countTokens() == 2) {
            return new Dimension(Integer.parseInt(st.nextToken()), Integer.parseInt(st.nextToken()));
        }
        Log.log(1, MODULE, "Parameter " + key + " = " + value + " is missing or malformed (should be width,height)");
        return null;
    }

    public void setDimensionProperty(String key, Dimension d) {
        this.setProperty(key, (int)d.getWidth() + "," + (int)d.getHeight());
    }

    public int getIntDimensionProperty(String key) {
        int i = this.getIntProperty(key + "1", -1);
        if (i == -1) {
            Dimension d = this.getDimensionProperty(key);
            i = d != null ? d.width : 0;
            this.setIntDimensionProperty(key, i);
        }
        return i;
    }

    public void setIntDimensionProperty(String key, int i) {
        this.setProperty(key + "1", String.valueOf(i));
    }

    public Color getColorProperty(String key) {
        StringTokenizer st;
        String value = this.getProperty(key);
        if (value == null) {
            return null;
        }
        if (value != null && (st = new StringTokenizer(value, ",")).countTokens() == 3) {
            return new Color(Integer.parseInt(st.nextToken()), Integer.parseInt(st.nextToken()), Integer.parseInt(st.nextToken()));
        }
        Log.log(1, MODULE, "Parameter " + key + " = " + value + " is missing or malformed (should be red,green,blue)");
        return null;
    }

    public void setColorProperty(String key, Color c) {
        this.setProperty(key, c.getRed() + "," + c.getGreen() + "," + c.getBlue());
    }

    public Rectangle getRectangleProperty(String key) {
        StringTokenizer st;
        String value = this.getProperty(key);
        if (value == null) {
            return null;
        }
        if (value != null && (st = new StringTokenizer(value, ",")).countTokens() == 4) {
            return new Rectangle(Integer.parseInt(st.nextToken()), Integer.parseInt(st.nextToken()), Integer.parseInt(st.nextToken()), Integer.parseInt(st.nextToken()));
        }
        Log.log(1, MODULE, "Parameter " + key + " is missing or malformed (should be x,y,width,height)");
        return null;
    }

    public void setRectangleProperty(String key, Rectangle rect) {
        this.setProperty(key, (int)rect.getX() + "," + (int)rect.getY() + "," + (int)rect.getWidth() + "," + (int)rect.getHeight());
    }

    public boolean getBooleanProperty(String key) {
        String booleanS = this.getProperty(key);
        if (booleanS != null) {
            if (booleanS.equalsIgnoreCase("yes") || booleanS.equalsIgnoreCase("true")) {
                return true;
            }
            if (booleanS.equalsIgnoreCase("no") || booleanS.equalsIgnoreCase("false")) {
                return false;
            }
        }
        throw new NumberFormatException("Parameter " + key + " = " + booleanS + " is missing or malformed (should be true/yes or false/no)");
    }

    public boolean getBooleanProperty(String key, boolean defaultValue) {
        try {
            return this.getBooleanProperty(key);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public void setBooleanProperty(String key, boolean value) {
        this.setProperty(key, value ? "true" : "false");
    }

    public int getIntProperty(String key) {
        String intS = this.getProperty(key);
        try {
            return Integer.valueOf(intS);
        }
        catch (Exception e) {
            throw new NumberFormatException("Parameter " + key + " = " + intS + " is missing or malformed (should be an integer value)");
        }
    }

    public int getIntProperty(String key, int defaultValue) {
        try {
            return this.getIntProperty(key);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public void setIntProperty(String key, int value) {
        this.setProperty(key, String.valueOf(value));
    }

    public String getBase64Property(String key) {
        String base64S = this.getProperty(key);
        if (base64S == null) {
            return null;
        }
        try {
            return Base64.decode(base64S);
        }
        catch (Error e) {
            throw new NumberFormatException("Parameter " + key + " = " + base64S + " is missing or malformed (should be a Base64 value)");
        }
    }

    public void setBase64Property(String key, String value) {
        this.setProperty(key, Base64.encode(value));
    }

    public Date getDateProperty(String key) {
        String dateS = this.getProperty(key);
        if (dateS == null) {
            return null;
        }
        try {
            return this.dateFormat.parse(dateS);
        }
        catch (ParseException e) {
            throw new NumberFormatException("Parameter " + key + " = " + dateS + " is missing or malformed (should be a Date value (yyyy/mm/dd))");
        }
    }

    public void setDateProperty(String key, Date date) {
        this.setProperty(key, this.dateFormat.format(date));
    }

    public String getProperty(String key, String defaultValue) {
        String tmp = this.getProperty(key);
        if (tmp == null) {
            return defaultValue;
        }
        return tmp;
    }

    public void logProperties(int level, String module) {
        if (module == null) {
            module = MODULE;
        }
        ArrayList names = new ArrayList(100);
        Enumeration<?> e = this.propertyNames();
        while (e.hasMoreElements()) {
            names.add(e.nextElement());
        }
        Object[] namesArray = names.toArray();
        Arrays.sort(namesArray);
        for (int i = 0; i < namesArray.length; ++i) {
            String name = (String)namesArray[i];
            Log.log(level, module, this.logPropertiesHelper(name));
        }
    }

    public String logPropertiesHelper(String name) {
        return name + "= |" + this.getProperty(name) + "|";
    }

    public void uncache() {
        this.thumbnailSize = null;
        this.mainBounds = null;
        this.previewBounds = null;
    }
}

