REM $Id: ora_objects.sql,v 1.2 2006/01/24 14:39:38 jonz Exp $

CREATE TABLE DSPAM_TOKEN_DATA (
  USER_ID NUMBER(5),
  TOKEN NUMBER,
  SPAM_HITS NUMBER,
  INNOCENT_HITS NUMBER,
  LAST_HIT DATE
)
/

CREATE UNIQUE INDEX ID_TOKEN_DATA_01 ON DSPAM_TOKEN_DATA(USER_ID,TOKEN);
CREATE INDEX ID_TOKEN_DATA_02 ON DSPAM_TOKEN_DATA(INNOCENT_HITS);
CREATE INDEX ID_TOKEN_DATA_03 ON DSPAM_TOKEN_DATA(SPAM_HITS);

CREATE TABLE DSPAM_SIGNATURE_DATA (
  USER_ID NUMBER(5),
  SIGNATURE VARCHAR2(128),
  DATA LONG,
  LENGTH NUMBER,
  CREATED_ON DATE
)
/

CREATE UNIQUE INDEX ID_SIGNATURE_DATA_01 ON 
  DSPAM_SIGNATURE_DATA(USER_ID,SIGNATURE);

CREATE TABLE DSPAM_STATS (
  USER_ID NUMBER(5) PRIMARY KEY,
  TOTAL_SPAM NUMBER,
  TOTAL_INNOCENT NUMBER,
  SPAM_MISSES NUMBER,
  FALSE_POSITIVES NUMBER,
  SPAM_CORPUSFED NUMBER,
  INNOCENT_CORPUSFED NUMBER,
  SPAM_CLASSIFIED NUMBER,
  INNOCENT_CLASSIFIED NUMBER
)
/

