#!/bin/sh

# A partial get of a repo shall have the same _darcs/pristine as the original

set -ev
test $DARCS || DARCS=$PWD/../darcs

rm -rf temp
mkdir temp
cd temp

# Create a developement repo, do some work

$DARCS initialize
echo ALL ignore-times >> _darcs/prefs/defaults
touch a
$DARCS add a
$DARCS record -a -m a -A x
touch b
$DARCS add b
$DARCS record -a -m b -A x

# Create a release repo, pull the good patches and tag it

mkdir _rel
cd _rel
$DARCS initialize
$DARCS pull -a --patch a ..
$DARCS tag -m t -A x
cd ..

# Pull the tag to the devel repo and continue developement

$DARCS pull -a _rel
touch c
$DARCS add c
$DARCS record -a -m c -A x

# Create a checkpoint and get a partial temp repo

$DARCS optimize --checkpoint
$DARCS get --partial . _partial

# We should have all our devel files

cd _partial
cat a
cat b
cat c
cd ..

cd ..
rm -rf temp
