#!/bin/sh

VERSION=2.1.3

if [ "$1" = "cross" ]; then
    export CROSSCOMPILE=/opt/Embedix/tools
    export QPEDIR=/opt/Qtopia/sharp
    export QTDIR=/opt/Qtopia/sharp
    export PATH=$QTDIR/bin:$QPEDIR/bin:$CROSSCOMPILE/bin:$PATH
    export TMAKEPATH=/opt/Qtopia/tmake/lib/qws/linux-sharp-g++/
    export LD_LIBRARY_PATH=$QTDIR/lib:$LD_LIBRARY_PATH
    export ARCHITECTURE=arm
    tmake -o Makefile zsafe.pro
    make
elif [ "$1" = "native" ]; then
    export CROSSCOMPILE=
    export QPEDIR=/opt/Qtopia
    export QTDIR=/usr/lib/qt3
    export PATH=$QTDIR/bin:$QPEDIR/bin:$PATH:/opt/Embedix/tools/bin
#    export TMAKEPATH=/opt/Qtopia/tmake/lib/qws/linux-x86-g++/
#    export TMAKEPATH=/opt/Qtopia/tmake/lib/qws/linux-generic-g++
    export TMAKEPATH=/opt/Qtopia/tmake/lib/linux-g++
    export LD_LIBRARY_PATH=$QTDIR/lib:$LD_LIBRARY_PATH
    export ARCHITECTURE=x86
    tmake -o Makefile zsafe_x86.pro
    make
else
    echo "usage: $0 cross | native"
    exit 1
fi

#tmake -o Makefile zsafe.pro
#make
lrelease zsafe.pro

for LANGUAGE in en de; do
    mkdir -p tmp/CONTROL
    mkdir -p tmp/opt/QtPalmtop/apps/Applications
    mkdir -p tmp/opt/QtPalmtop/bin
    mkdir -p tmp/opt/QtPalmtop/pics
    if [ "$LANGUAGE" != "en" ]; then
	mkdir -p tmp/opt/QtPalmtop/help/${LANGUAGE}/html
	mkdir -p tmp/opt/QtPalmtop/i18n/${LANGUAGE}
    else
	mkdir -p tmp/opt/QtPalmtop/help/html
    fi
    cp zsafe.desktop tmp/opt/QtPalmtop/apps/Applications
    cp zsafe tmp/opt/QtPalmtop/bin
    cp zsafe.png tmp/opt/QtPalmtop/pics
    if [ "$LANGUAGE" != "en" ]; then
	cp help/${LANGUAGE}/zsafe.html tmp/opt/QtPalmtop/help/${LANGUAGE}/html
	cp i18n/${LANGUAGE}/zsafe.qm tmp/opt/QtPalmtop/i18n/${LANGUAGE}
    else
	cp help/en/zsafe.html tmp/opt/QtPalmtop/help/html
    fi
    cat > tmp/CONTROL/control <<END
Version: ${VERSION}
Depends: qpe-base (\$QPE_VERSION)
Priority: optional
Section: Applications
Maintainer: Carsten Schneider <zcarsten@gmx.net>
Architecture: ${ARCHITECTURE}
License: GPL
Description: ZSafe
 A password manager program for the Zaurus.
END
    if [ "$LANGUAGE" != "en" ]; then
	cat >> tmp/CONTROL/control <<END
Package: zsafe-${LANGUAGE}
Files: bin/zsafe apps/Applications/zsafe.desktop pics/zsafe.png help/${LANGUAGE}/html/zsafe.html
Filename: ./zsafe-${LANGUAGE}_${VERSION}_${ARCHITECTURE}.ipk
END
    else
	cat >> tmp/CONTROL/control <<END
Package: zsafe
Files: bin/zsafe apps/Applications/zsafe.desktop pics/zsafe.png help/html/zsafe.html
Filename: ./zsafe_${VERSION}_${ARCHITECTURE}.ipk
END
    fi
    ipkg-build tmp
    rm -rf tmp
done

