##############################################################################
#
# Copyright (c) 2001, 2002 Zope Corporation and Contributors.
# All Rights Reserved.
# 
# This software is subject to the provisions of the Zope Public License,
# Version 2.0 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE
# 
##############################################################################
"""
Revision information:
$Id: testBackTalkBase.py,v 1.3 2002/06/08 19:28:13 chrism Exp $
"""
import os, sys, re, string

sys.path.insert(0, '../../..')
sys.path.insert(0, '..')

from unittest import TestCase, TestSuite, TextTestRunner, makeSuite
try: import ZODB
except: pass

from Products.BackTalk.CommentableDocument import CommentableDocument
from Products.BackTalk.BackTalkBase import BasicWithIds, SourceDocument, \
     insertComment
from StructuredText import Basic

## try:
##     from Products.BackTalk.BackTalkBase import CommentableDocument,\
##          HTMLWithComments, SourceDocument, insertComment, BasicWithIds
## except:
##     from BackTalkBase import CommentableDocument, HTMLWithComments, \
##          SourceDocument, insertComment, BasicWithIds
    
testfile = os.path.join(INSTANCE_HOME, 'Products', 'BackTalk',
                        'tests', 'constitution.stx')
textfixture = open(testfile).read()

class TestBackTalkBase(TestCase):
    def setUp(self):
        self.text = textfixture
        self.st = BasicWithIds(self.text)
        
    def checkBasicWithIdsMatchesBasic(self):
        st = self.st
        assert len(st.getChildren()) == 6
        lens = (1, 1, 17, 1, 14, 1)
        i = 0
        for x in st.getChildren():
            numchildren = len(x.getChildren())
            assert numchildren == lens[i],\
                   (numchildren, lens[i], x.getChildren())
            i = i + 1
        st = Basic(self.text)
        assert len(st.getChildren()) == 6
        lens = (1, 1, 17, 1, 14, 1)
        i = 0
        for x in st.getChildren():
            numchildren = len(x.getChildren())
            assert numchildren == lens[i],\
                   (numchildren, lens[i], x.getChildren())
            i = i + 1

    def checkSourceDocument(self,paragraph_delimiter = re.compile('\n\s*\n'),
                            split=string.split, strip=string.strip):
        src_text = self.text
        result_txt = SourceDocument(self.st)
        src_text = string.expandtabs( '\n\n' + src_text + '\n\n')
        result_txt = string.expandtabs( '\n\n' + result_txt + '\n\n')
        src_paragraphs=filter(strip, paragraph_delimiter.split(src_text))
        result_paragraphs=filter(strip, paragraph_delimiter.split(result_txt))
        i = 0
        for paragraph in src_paragraphs:
            assert paragraph == result_paragraphs[i], paragraph
            i = i + 1

    def dontcheckCommentableDocument(self):
        raw = BasicWithIds(self.text)
        doc = CommentableDocument(raw)
        import pdb
        pdb.set_trace()
        while 1: pass
        
def test_suite():
    s1 = makeSuite(TestBackTalkBase, 'check')
    testsuite = TestSuite((s1,))
    return testsuite

def main():
    alltests=test_suite()
    runner = TextTestRunner()
    runner.run(alltests)

def debug():
    test_suite().debug()

if __name__=='__main__':
   if len(sys.argv) > 1:
      globals()[sys.argv[1]]()
   else:
       main()
