/* $Id: tcd.h,v 1.4 2003/03/18 20:40:08 flaterco Exp $ */

#ifndef __OAML_TIDES_H__
#define __OAML_TIDES_H__


/*****************************************************************************\

                            DISTRIBUTION STATEMENT

    This source file is unclassified, distribution unlimited, public
    domain.  It is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

\*****************************************************************************/



#ifdef  __cplusplus
extern "C" {
#endif


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <malloc.h>
#include <errno.h>
#include <time.h>
#include <math.h>
#include <ctype.h>
#include <assert.h>
#include "nvtypes.h"


/*  Maximum values.  */

#define NAME_LENGTH         90
#define SOURCE_LENGTH       90
#define COMMENTS_LENGTH     1500

#define MAX_CONSTITUENTS    255



/*  Public portion of the database header.  */

typedef struct
{
    NV_CHAR           version[80];
    NV_CHAR           last_modified[30];
    NV_INT32          number_of_records;
    NV_INT32          start_year;
    NV_INT32          number_of_years;
    NV_INT32          constituents;
    NV_INT32          level_unit_types;
    NV_INT32          dir_unit_types;
    NV_INT32          restriction_types;
    NV_INT32          pedigree_types;
    NV_INT32          datum_types;
    NV_INT32          countries;
    NV_INT32          tzfiles;
} DB_HEADER_PUBLIC;


/*  Header portion of each station record.  */

typedef struct
{
    NV_INT32                record_number;
    NV_INT32                record_size;
    NV_U_BYTE               record_type;
    NV_FLOAT64              latitude;
    NV_FLOAT64              longitude;
    NV_INT32                reference_station;
    NV_INT16                tzfile;
    NV_CHAR                 name[NAME_LENGTH];
} TIDE_STATION_HEADER;


/*  Tide station record.  */

typedef struct
{
    TIDE_STATION_HEADER     header;
    NV_INT16                country;
    NV_INT16                pedigree;
    NV_CHAR                 source[SOURCE_LENGTH];
    NV_U_BYTE               restriction;
    NV_CHAR                 comments[COMMENTS_LENGTH];
    NV_U_BYTE               units;
    NV_FLOAT32              datum_offset;
    NV_INT16                datum;
    NV_INT32                zone_offset;
    NV_U_INT32              expiration_date;
    NV_U_BYTE               months_on_station;
    NV_U_INT32              last_date_on_station;
    NV_U_BYTE               confidence;
    NV_FLOAT32              amplitude[MAX_CONSTITUENTS];
    NV_FLOAT32              epoch[MAX_CONSTITUENTS];
    NV_U_BYTE               level_units;
    NV_U_BYTE               avg_level_units;
    NV_U_BYTE               direction_units;
    NV_INT32                min_time_add;
    NV_FLOAT32              min_level_add;
    NV_FLOAT32              min_level_multiply;
    NV_FLOAT32              min_avg_level;
    NV_INT32                min_direction;
    NV_INT32                max_time_add;
    NV_FLOAT32              max_level_add;
    NV_FLOAT32              max_level_multiply;
    NV_FLOAT32              max_avg_level;
    NV_INT32                max_direction;
    NV_INT32                flood_begins;
    NV_INT32                ebb_begins;
} TIDE_RECORD;


/* DWF: This value signifies "null" or "omitted" slack offsets
   (flood_begins, ebb_begins).  Zero is *not* the same. */
/* Time offsets are represented as hours * 100 plus minutes.  None should
   ever exceed 24:00.  0xA00 = 2560 */
#define NULLSLACKOFFSET 0xA00

#define NINT(a)   ((a)<0.0 ? (NV_INT32) ((a) - 0.5) : (NV_INT32) ((a) + 0.5))


/*  Public function prototypes.  */

void dump_tide_record (TIDE_RECORD *rec);
NV_CHAR *get_country (NV_INT32 num);
NV_CHAR *get_tzfile (NV_INT32 num);
NV_CHAR *get_station (NV_INT32 num);
NV_CHAR *get_constituent (NV_INT32 num);
NV_CHAR *get_level_units (NV_INT32 num);
NV_CHAR *get_dir_units (NV_INT32 num);
NV_CHAR *get_restriction (NV_INT32 num);
NV_CHAR *get_pedigree (NV_INT32 num);
NV_CHAR *get_datum (NV_INT32 num);
NV_FLOAT64 get_speed (NV_INT32 num);
NV_FLOAT32 get_equilibrium (NV_INT32 num, NV_INT32 year);
NV_FLOAT32 get_node_factor (NV_INT32 num, NV_INT32 year);
NV_BOOL get_partial_tide_record (NV_INT32 num, TIDE_STATION_HEADER *rec);
NV_INT32 get_next_partial_tide_record (TIDE_STATION_HEADER *rec);
NV_INT32 get_nearest_partial_tide_record (NV_FLOAT64 lat, NV_FLOAT64 lon,
                                          TIDE_STATION_HEADER *rec);

NV_INT32 get_time (NV_CHAR *string);
NV_CHAR *ret_time (NV_INT32 time);

DB_HEADER_PUBLIC get_tide_db_header ();

NV_INT32 search_station (NV_CHAR *string);

NV_INT32 find_station (NV_CHAR *name);
NV_INT32 find_tzfile (NV_CHAR *tname);
NV_INT32 find_country (NV_CHAR *tname);
NV_INT32 find_level_units (NV_CHAR *tname);
NV_INT32 find_dir_units (NV_CHAR *tname);
NV_INT32 find_restriction (NV_CHAR *tname);
NV_INT32 find_pedigree (NV_CHAR *tname);
NV_INT32 find_datum (NV_CHAR *tname);
NV_INT32 find_constituent (NV_CHAR *name);

void set_speed (NV_INT32 num, NV_FLOAT64 value);
void set_equilibrium (NV_INT32 num, NV_INT32 year, NV_FLOAT32 value);
void set_node_factor (NV_INT32 num, NV_INT32 year, NV_FLOAT32 value);

NV_INT32 add_restriction (NV_CHAR *tname, DB_HEADER_PUBLIC *db);
NV_INT32 add_pedigree (NV_CHAR *tname, DB_HEADER_PUBLIC *db);
NV_INT32 add_tzfile (NV_CHAR *tname, DB_HEADER_PUBLIC *db);
NV_INT32 add_country (NV_CHAR *tname, DB_HEADER_PUBLIC *db);
NV_INT32 add_datum (NV_CHAR *tname, DB_HEADER_PUBLIC *db);

NV_BOOL check_simple (TIDE_RECORD rec);

NV_BOOL open_tide_db (NV_CHAR *file);
void close_tide_db ();
NV_BOOL create_tide_db (NV_CHAR *file, NV_INT32 constituents, 
    NV_CHAR *constituent[], NV_FLOAT64 *speed, NV_INT32 start_year, 
    NV_INT32 num_years, NV_FLOAT32 *equilibrium[], 
    NV_FLOAT32 *node_factor[]);

NV_BOOL write_tide_record (NV_INT32 num, TIDE_RECORD *rec);
NV_INT32 read_next_tide_record (TIDE_RECORD *rec);
NV_INT32 read_tide_record (NV_INT32 num, TIDE_RECORD *rec);
NV_BOOL add_tide_record (TIDE_RECORD *rec, DB_HEADER_PUBLIC *db);
void delete_tide_record (NV_INT32 num, DB_HEADER_PUBLIC *db);
NV_BOOL update_tide_record (NV_INT32 num, TIDE_RECORD *rec);
NV_BOOL infer_constituents (TIDE_RECORD *rec);

#ifdef  __cplusplus
}
#endif

#endif
