#ifndef NIGNORE_H
#define NIGNORE_H

#include "local_config.h"

#ifdef CAN_USE_NIGNORE

#include <string>
#include <vector>
#include "ref.h"
#include "leoini.h"
#include <iostream>

class Node;

class NIgnore
{
 public:
    enum MatchType
    {
	MATCH_FALSE = 0,
	MATCH_TRUE,
	MATCH_REQUIRE_NEXT
    };

 private:
    std::string name;

    std::vector<std::string> dir;
    bool                     follow;


    bool is_valid;

 public:
    NIgnore( const std::string &name, Leo::Ini &ini );

    MatchType match( Ref<Node> node, std::string & strip );

    bool valid() const { return is_valid; }

    std::string getName() const { return name; }

    friend std::ostream & operator<<( std::ostream &out, Ref<NIgnore> ni );
    
 private:
    MatchType match_dir( Ref<Node> node, std::string & strip );
};

std::ostream & operator<<( std::ostream &out, Ref<NIgnore> ni );

class NIgnoreChain
{
    std::vector< Ref<NIgnore> > nignores;
 public:

    NIgnoreChain() {}

    void add( Ref<NIgnore> ni ) { nignores.push_back( ni ); }

    bool match( Ref<Node> node );

    unsigned size() const { return nignores.size(); }
    bool empty() const { return nignores.size(); }

    std::string getName();

    friend std::ostream & operator<<( std::ostream &out, Ref<NIgnoreChain> nc );
};

std::ostream & operator<<( std::ostream &out, Ref<NIgnoreChain> nc );

#endif

#endif
