#include "xgdipc.h" 


void restore_window (GtkWidget *thisw, GtkWidget *widget) {

   gtk_widget_hide(widget);
}


int main (int argc, char *argv[]) {
 GtkWidget *window;
 GtkWidget *table;
 GtkWidget *button;
 GtkWidget *label;
 GtkTooltips *tooltips;
 GtkWidget *main_vbox;
 GtkWidget *pixmapwid;
 GdkBitmap *mask;
 GdkPixmap *pixmap;
 GtkStyle *style;

#if (GTK_MINOR_VERSION < 1 && GTK_MAJOR_VERSION <= 1)
 GtkWidget *menubar;
#endif
 
 FILE *infile;
 
 gtk_init (&argc, &argv);

 window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
 gtk_window_set_title (GTK_WINDOW (window), "X-GnuDIP2");
 gtk_container_border_width (GTK_CONTAINER (window), 1);

 main_vbox = gtk_vbox_new(FALSE, 5);
 gtk_container_border_width(GTK_CONTAINER(main_vbox), 1);
 gtk_widget_show(main_vbox);

#if (GTK_MINOR_VERSION < 1 && GTK_MAJOR_VERSION <= 1)

 get_main_menu(window, &menubar);
 gtk_box_pack_start(GTK_BOX(main_vbox), menubar, FALSE, TRUE, 0);
 gtk_widget_show(menubar);

#else

 get_main_menu(window, main_vbox);

#endif

 gtk_window_set_policy (GTK_WINDOW (window), FALSE, FALSE, FALSE);
 gtk_signal_connect (GTK_OBJECT (window), "delete_event", GTK_SIGNAL_FUNC (gtk_main_quit), NULL);
 gtk_signal_connect (GTK_OBJECT (window), "destroy", GTK_SIGNAL_FUNC (gtk_main_quit), NULL);
 gtk_widget_realize(window);

 table = gtk_table_new (11, 2, TRUE);
 gtk_widget_show(table);
 gtk_table_set_col_spacing(GTK_TABLE(table), 0, 20);
 
 tooltips = gtk_tooltips_new();

 gtk_container_add (GTK_CONTAINER (window), table);

 style = gtk_widget_get_style (window);  
 pixmap = gdk_pixmap_create_from_xpm (GTK_WIDGET(window)->window, &mask,
				      &style->bg[GTK_STATE_NORMAL],
#ifdef XPMPATH
				      XPMPATH);
#else
				      "xgdip.xpm");
#endif

 pixmapwid = gtk_pixmap_new (pixmap, mask);
 gtk_widget_show(pixmapwid);

 gtk_table_attach_defaults (GTK_TABLE (table), main_vbox, 0, 2, 0, 1);
 gtk_table_attach_defaults (GTK_TABLE (table), pixmapwid, 0, 2, 1, 3);

 label = gtk_label_new("Username");
 gtk_table_attach_defaults (GTK_TABLE (table), label, 0, 1, 3, 4);
 gtk_widget_show(label);

 text1 = gtk_entry_new();
 gtk_table_attach_defaults (GTK_TABLE (table), text1, 1, 2, 3, 4);
 gtk_tooltips_set_tip (tooltips, text1, "Enter your username here", NULL);
 gtk_widget_show(text1);

 label = gtk_label_new("Password");
 gtk_table_attach_defaults (GTK_TABLE (table), label, 0, 1, 4, 5);
 gtk_widget_show(label);
 
 text2 = gtk_entry_new();
 gtk_table_attach_defaults (GTK_TABLE (table), text2, 1, 2, 4, 5);
 gtk_tooltips_set_tip (tooltips, text2, "Enter your password here", NULL); 
 gtk_entry_set_visibility (GTK_ENTRY(text2), FALSE);
 gtk_widget_show(text2);

 label = gtk_label_new("Domain");
 gtk_table_attach_defaults (GTK_TABLE (table), label, 0, 1, 5, 6);
 gtk_widget_show(label);
 
 text4 = gtk_entry_new();
 gtk_table_attach_defaults (GTK_TABLE (table), text4, 1, 2, 5, 6);
 gtk_tooltips_set_tip (tooltips, text4, "Enter the domain of your dynamic hostname", NULL); 
 gtk_widget_show(text4);

 label = gtk_label_new("Server");
 gtk_table_attach_defaults (GTK_TABLE (table), label, 0, 1, 6, 7);
 gtk_widget_show(label);

 text3 = gtk_entry_new();
 gtk_table_attach_defaults (GTK_TABLE (table), text3, 1, 2, 6, 7);
 gtk_tooltips_set_tip (tooltips, text3, "Enter your server name here", NULL);
 gtk_widget_show(text3);   

 checkbutton = gtk_check_button_new_with_label ("Save Password");
 gtk_table_attach_defaults (GTK_TABLE (table), checkbutton, 1, 2, 7, 8);
 gtk_tooltips_set_tip (tooltips, checkbutton, "Saves or does not save password", NULL);
 gtk_widget_show(checkbutton);

 checkbutton1 = gtk_check_button_new_with_label ("Auto Exit on Success");
 gtk_table_attach_defaults (GTK_TABLE (table), checkbutton1, 1, 2, 8, 9);
 gtk_tooltips_set_tip (tooltips, checkbutton1, "Automatically exit X-GnuDIP2 after successful login", NULL); 
 gtk_widget_show(checkbutton1);

 mode_update = gtk_radio_button_new_with_label(NULL, "Update Hostname");
 gtk_table_attach_defaults(GTK_TABLE(table), mode_update, 0, 1, 7, 8);
 gtk_tooltips_set_tip (tooltips, mode_update, "Point hostname to current IP", NULL); 
 gtk_widget_show(mode_update);

 mode_offline = gtk_radio_button_new_with_label(gtk_radio_button_group(GTK_RADIO_BUTTON(mode_update)), "Send Offline");
 gtk_table_attach_defaults(GTK_TABLE(table), mode_offline, 0, 1, 8, 9); 
 gtk_tooltips_set_tip (tooltips, mode_offline, "Unpoint hostname until next update", NULL); 
 gtk_widget_show(mode_offline);

#if (GTK_MINOR_VERSION >= 1 && GTK_MAJOR_VERSION >= 1)
 gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(mode_update), TRUE); 
#endif

 button = gtk_button_new_with_label ("OK");
 gtk_table_attach_defaults (GTK_TABLE (table), button, 0, 1, 10, 11);
 gtk_tooltips_set_tip (tooltips, button, "Login to the server", NULL); 
 gtk_signal_connect_object (GTK_OBJECT (button), "clicked", GTK_SIGNAL_FUNC(connect_to), GTK_OBJECT (window));
 gtk_widget_show(button);

 button = gtk_button_new_with_label ("Cancel");
 gtk_table_attach_defaults (GTK_TABLE (table), button, 1, 2, 10, 11);
 gtk_signal_connect (GTK_OBJECT (button), "clicked", GTK_SIGNAL_FUNC (gtk_main_quit), NULL);
 gtk_tooltips_set_tip (tooltips, button, "Quit X-GnuDIP2", NULL);
 gtk_widget_show(button); 

 sprintf (path_xgdip2, "%s/.XGnuDIP2", getenv("HOME")); 
 if ((infile = fopen(path_xgdip2, "r")) == NULL) {
  gdip_savepass = 'n';
  gdip_autoquit = 'n';
  strcpy(gdip_server,"");
  strcpy(gdip_username,"");
  strcpy(gdip_domain,"");
  strcpy(gdip_pass,"");
 } else {
  fscanf(infile, "%c %c %s %s %s %s", &gdip_savepass, &gdip_autoquit, gdip_server, gdip_username, gdip_domain, gdip_pass);
 fclose(infile);
 }
  
  if (gdip_savepass == 'y')
    gtk_toggle_button_set_state( GTK_TOGGLE_BUTTON(checkbutton), TRUE); 
 
  if (gdip_autoquit == 'y')
    gtk_toggle_button_set_state( GTK_TOGGLE_BUTTON(checkbutton1), TRUE);

  if (gdip_savepass == 'y')
    gtk_entry_set_text (GTK_ENTRY(text2), gdip_pass);

  gtk_entry_set_text (GTK_ENTRY(text1), gdip_username);
  gtk_entry_set_text (GTK_ENTRY(text3), gdip_server);
  gtk_entry_set_text (GTK_ENTRY(text4), gdip_domain);
 
 gtk_widget_show (table);
 gtk_widget_show (window);

 gtk_main();
 
 return(0);
}
