#include "xgdipc.h"


#if (GTK_MINOR_VERSION < 1 && GTK_MAJOR_VERSION <= 1)

static GtkMenuEntry menu[] = {
        {"<Main>/File/About", "<control>A", show_about, NULL},
        {"<Main>/File/<separator>", NULL, NULL, NULL},
        {"<Main>/File/Exit", "<control>X", gtk_main_quit, NULL} 
};

void get_main_menu(GtkWidget *window, GtkWidget **menubar) {
           int nmenu_items = sizeof(menu) / sizeof(menu[0]);
           GtkMenuFactory *factory;
           GtkMenuFactory *subfactory;

           factory = gtk_menu_factory_new(GTK_MENU_FACTORY_MENU_BAR);
           subfactory = gtk_menu_factory_new(GTK_MENU_FACTORY_MENU_BAR);

           gtk_menu_factory_add_subfactory(factory, subfactory, "<Main>");
           gtk_menu_factory_add_entries(factory, menu, nmenu_items);
           gtk_window_add_accelerator_table(GTK_WINDOW(window), subfactory->table);
           
           if (menubar)
               *menubar = subfactory->widget;
 }


#else

void get_main_menu(GtkWidget *window, GtkWidget *vbox) {
   GtkWidget *menubar;
   GtkWidget *menubox;
   GtkAccelGroup *accel;
   GtkItemFactory *factory;

   GtkItemFactoryEntry menu[] = {
       {"/_File", "<alt>F", NULL, 0, "<Branch>"},
       {"/File/About", "<control>A", show_about, 0},
       {"/File/sep1", NULL, NULL, 0, "<Separator>"},
       {"/File/Exit", "<control>X", gtk_main_quit, 0} 
    };

   int nmenu_items = sizeof(menu) / sizeof(menu[0]);

   accel = gtk_accel_group_new();
   factory = gtk_item_factory_new( GTK_TYPE_MENU_BAR, "<Main>", accel );
   gtk_item_factory_create_items(factory, nmenu_items, menu, NULL);

   menubar = gtk_item_factory_get_widget( factory, "<Main>" );
   menubox = gtk_handle_box_new();
   gtk_accel_group_attach( accel, GTK_OBJECT(window ) );
   gtk_container_add(GTK_CONTAINER(menubox), menubar);
   gtk_box_pack_start(GTK_BOX(vbox), menubox, FALSE, TRUE, 0);
   gtk_widget_show(menubox);
   gtk_widget_show(menubar); 
 }

#endif

void show_about(GtkWidget *widget, gpointer data) {

  GtkWidget *window;
  GtkWidget *table; 
  GtkWidget *label1;
  GtkWidget *label2;
  GtkWidget *button;

 GtkWidget *box1;
 GtkWidget *pixmapwid;
 GdkBitmap *mask;
 GdkPixmap *pixmap;
 GtkStyle *style;

  window = gtk_window_new(GTK_WINDOW_DIALOG);
  gtk_signal_connect(GTK_OBJECT(window), "destroy", GTK_SIGNAL_FUNC(gtk_widget_destroy), window);
  gtk_window_set_title(GTK_WINDOW(window), "About: X-GnuDIP2");
  gtk_window_set_policy (GTK_WINDOW (window), FALSE, FALSE, FALSE);
  gtk_widget_realize(window);
  
  table = gtk_table_new(8, 4, TRUE);
  gtk_container_add(GTK_CONTAINER(window), table);

   style = gtk_widget_get_style (window);
  pixmap = gdk_pixmap_create_from_xpm (GTK_WIDGET(window)->window, &mask,
                                      &style->bg[GTK_STATE_NORMAL],
#ifdef XPMPATH
                                      XPMPATH);
#else
                                      "xgdip.xpm");
#endif

 pixmapwid = gtk_pixmap_new (pixmap, mask);
 gtk_widget_show(pixmapwid);


  label1 = gtk_label_new("By: Mike Machado <mike@innercite.com>");
  label2 = gtk_label_new("    Ryan Wahle <wahle@innercite.com>");

  gtk_widget_show(label1);
  gtk_widget_show(label2);

  gtk_table_attach_defaults (GTK_TABLE (table), pixmapwid, 0, 4, 2, 4);
  gtk_table_attach_defaults (GTK_TABLE (table), label1, 0, 4, 5, 6);
  gtk_table_attach_defaults (GTK_TABLE (table), label2, 0, 4, 6, 7);

  button = gtk_button_new_with_label ("Ok");
  gtk_signal_connect_object (GTK_OBJECT (button), "clicked", GTK_SIGNAL_FUNC(gtk_widget_destroy), GTK_OBJECT(window));
  gtk_widget_show(button);
    

  gtk_table_attach_defaults (GTK_TABLE (table), button, 1, 3, 7, 8);

  gtk_widget_show(table);
  gtk_widget_show(window); 

}
