/*
 * xconvers - GTK+ convers client for amateur radio
 * Copyright (C) 2000-2003 Joop Stakenborg <pg4i@amsat.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*
 * history.c - private functions for handling connect and transmit history.
 */

#include <stdio.h>
#include "support.h"
#include "history.h"

#define TXHISTORY       10

extern GtkWidget *mainwindow;
extern gchar *preferencesdir;
extern GList *txhistory, *hostnamehistory, *porthistory;
guint txitem = 0, updown = 0;

/*
 * Recall history and copy into the appropriate GList.
 */
 
void loadhistory(void)
{
  gchar *historyfile, history[1024], **histsplit = NULL;
  FILE *fp;

  historyfile = g_strconcat(preferencesdir, "/history", NULL);
  fp = fopen(historyfile,"r");
  if (fp == NULL) return;
  while(!feof(fp))
  {
    if (fscanf(fp,"%s", history) == EOF) break;
    histsplit = g_strsplit(history, ":", 2);
    if (!g_strcasecmp(histsplit[0], "tx"))
    {
      g_strdelimit(histsplit[1], "_", ' ');
      txhistory = g_list_append(txhistory, g_string_new(histsplit[1]));
      txitem = g_list_length(txhistory);
    }
    else if (!g_strcasecmp(histsplit[0], "ho"))
      hostnamehistory = g_list_append(hostnamehistory, g_strdup(histsplit[1]));
      else if (!g_strcasecmp(histsplit[0], "po"))
        porthistory = g_list_append(porthistory, g_strdup(histsplit[1]));
  }
  fclose(fp);
  g_strfreev(histsplit);
}

/*
 * Save history to ~/.xconvers/history for tx widget, hostname combobox and
 * port combobox.
 */
 
void savehistory(void)
{
  gchar *historyfile;
  FILE *fp;
  gchar *history;
  guint i, n;
  GString *tx;

  historyfile = g_strconcat(preferencesdir, "/history", NULL);
  if ((g_list_length(txhistory) > 0) || (g_list_length(hostnamehistory) > 0)
    || (g_list_length(porthistory) > 0))
  {
    fp = fopen(historyfile, "w");
    if (fp == NULL) return;
    if ((n = g_list_length(txhistory)) > 0)
    {
      for(i=0; i<n; i++)
      {
        tx = g_list_nth_data(txhistory, i);
        if (tx->len > 0) {
        g_strdelimit(tx->str, " ", '_');
        fprintf(fp, "tx:%s\n", tx->str);
        }
      }
    }
    if ((n = g_list_length(hostnamehistory)) > 0)
    {
      for(i=0; i<n; i++)
      {
        history = g_list_nth_data(hostnamehistory, i);
        fprintf(fp, "ho:%s\n", history);
      }
    }
    if ((n = g_list_length(porthistory)) > 0)
    {
      for(i=0; i<n; i++)
      {
        history = g_list_nth_data(porthistory, i);
        fprintf(fp, "po:%s\n", history);
      }
    }
    fclose(fp);
  }
}

/*
 * Save strings that are typed in the tx widget, up to a maximum of 
 * TXHISTORY. The number of lines transmitted is saved.
 */

void tx_save(GString *line)
{
  txhistory = g_list_append(txhistory, g_string_new(line->str));
  if (g_list_length(txhistory) > TXHISTORY)
    txhistory = g_list_remove(txhistory, g_list_first(txhistory)->data);
    else txitem++; 
  updown = 0;
}

/*
 * Up Arrow is hit. We save the numer of times that this key is hit. The 
 * corresponding saved item from the tx widget is displayed.
 */

void tx_previous(void)
{
  GtkWidget *mainentry;
  GList *node;
  gchar *tempstr;

  if (updown < txitem) updown++;
  if (txhistory)
  {
    node = g_list_nth_data(txhistory, txitem-updown);
    tempstr = g_strdup(node->data);
    mainentry = lookup_widget (mainwindow, "mainentry");
    gtk_entry_set_text(GTK_ENTRY(mainentry), tempstr);
  }
}

/*
 * Same story as tx_previous. Special care is taken when the Down Arrow is hit
 * after the last element in the list has been passed. The transmit widget
 * is then cleared.
 */

void tx_next(void)
{
  GtkWidget *mainentry;
  GList *node;
  gchar *tempstr;

  mainentry = lookup_widget (mainwindow, "mainentry");
  if (updown > 0) updown--;
  if (updown == 0)
    gtk_entry_set_text(GTK_ENTRY(mainentry), "");
    else
    {
      node = g_list_nth_data(txhistory, txitem-updown);
      tempstr = g_strdup(node->data);
      gtk_entry_set_text(GTK_ENTRY(mainentry), tempstr);
    }
}
