/*
 *   Copyright (C) 2002-2004 by Jonathan Naylor G4KLX
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "JT44MessageEvent.h"

CJT44MessageEvent::CJT44MessageEvent(CJT44Message* message, EWho who, wxEventType type, int id) :
wxEvent(id, type),
m_message(message),
m_who(who)
{
}

CJT44MessageEvent::CJT44MessageEvent(const CJT44MessageEvent& event) :
wxEvent(event),
m_message(event.m_message),
m_who(event.m_who)
{
}

CJT44MessageEvent::~CJT44MessageEvent()
{
}

CJT44Message* CJT44MessageEvent::getMessage() const
{
	return m_message;
}

EWho CJT44MessageEvent::getWho() const
{
	return m_who;
}

wxEvent* CJT44MessageEvent::Clone() const
{
	return new CJT44MessageEvent(*this);
}
