/*
 *   Copyright (C) 2002-2004 by Jonathan Naylor G4KLX
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "LevelEvent.h"

CLevelEvent::CLevelEvent(double audio, EWho who, wxEventType type, int id) :
wxEvent(id, type),
m_audio(audio),
m_who(who)
{
}

CLevelEvent::CLevelEvent(const CLevelEvent& event) :
wxEvent(event),
m_audio(event.m_audio),
m_who(event.m_who)
{
}

CLevelEvent::~CLevelEvent()
{
}

double CLevelEvent::getAudio() const
{
	return m_audio;
}

EWho CLevelEvent::getWho() const
{
	return m_who;
}

wxEvent* CLevelEvent::Clone() const
{
	return new CLevelEvent(*this);
}
