/*
 *   Copyright (C) 2002-2004 by Jonathan Naylor G4KLX
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef JT6MFileReceive_H
#define	JT6MFileReceive_H

#include "JT6MReceive.h"
#include "JT6MLevels.h"
#include "JT6MMessage.h"

class CJT6MFileReceive : public CJT6MReceive {

    public:
	CJT6MFileReceive(const wxString& name, EWho who);
	virtual ~CJT6MFileReceive();

	virtual void setFileName(const wxString& fileName);

	virtual void openSoundDevice();
	virtual ISoundDev* getSoundDevice()
	{
		wxASSERT(m_soundDev != NULL);
		return m_soundDev;
	}
	virtual void closeSoundDevice();

	virtual bool getEndTime();

	virtual void recordAudio(const wxString& id, double* audioData, int length) const;

	virtual wxString createId();

	virtual void error(const wxString& text);

    private:
    	wxString   m_fileName;
	ISoundDev* m_soundDev;
};

#endif
