// $Id: GLModelView.cpp,v 1.7 2003/02/09 21:34:41 zongo Exp $

#include <vector>
#include <string>
#include <iostream>

#ifdef WIN32
# include <windows.h>
#endif

#include <GL/glu.h>

#include <gtk/gtksignal.h>

#include "../Application.h"
#include "GLModelView.h"


////////////////////////////////////////////////////////////////////////


GLModelView::GLModelView()
  : GLView()
{
}

GLModelView::~GLModelView()
{
}


bool
GLModelView::Motion(int x, int y, int state, int lastx, int lasty)
{
   Redraw();
   return true;
}

static void modelview_SetLight(Ark::Vector3 light0Pos)
{
   GLfloat light0Amb[4] = {0.20, 0.20, 0.20, 1.00};
   GLfloat light0Diff[4] = {1.00, 1.00, 1.00, 1.00};
   GLfloat light0Spec[4] = {1.00, 1.00, 1.00, 1.00};
   GLfloat light0SpotDir[3] = {0.00, 1.00, 1.00};
   
   GLfloat light0SpotExp = 0.00;
   GLfloat light0SpotCutoff = 180.00;
   GLfloat light0Atten0 = 1.00;
   GLfloat light0Atten1 = 0.00;
   GLfloat light0Atten2 = 0.00;
   
   glEnable(GL_LIGHT0);
   glLightfv(GL_LIGHT0, GL_POSITION, &light0Pos.X);
   glLightfv(GL_LIGHT0, GL_AMBIENT, light0Amb);
   glLightfv(GL_LIGHT0, GL_DIFFUSE, light0Diff);
   glLightfv(GL_LIGHT0, GL_SPECULAR, light0Spec);
   glLightfv(GL_LIGHT0, GL_SPOT_DIRECTION, light0SpotDir);
   glLightf(GL_LIGHT0, GL_SPOT_EXPONENT, light0SpotExp);
   glLightf(GL_LIGHT0, GL_SPOT_CUTOFF, light0SpotCutoff);
   glLightf(GL_LIGHT0, GL_CONSTANT_ATTENUATION, light0Atten0);
   glLightf(GL_LIGHT0, GL_LINEAR_ATTENUATION, light0Atten1);
   glLightf(GL_LIGHT0, GL_QUADRATIC_ATTENUATION, light0Atten2);
}


bool
GLModelView::Render()
{
   const int w = GTK_WIDGET(m_Area)->allocation.width;
   const int h = GTK_WIDGET(m_Area)->allocation.height;

   m_Renderer->SetViewport(0, 0, w, h);
   glClear(GL_DEPTH_BUFFER_BIT|GL_COLOR_BUFFER_BIT);

   if (m_ModelState.GetModel() != NULL)
   {
      Ark::BBox box = m_ModelState.ExtractBbox();

      m_ModelState.Update(m_Timer.GetDelta());
      
      scalar fact = box.m_Max.Y - box.m_Min.Y;

      Ark::Camera cam;
      cam.m_LookAt = 0.5 * (box.m_Min + box.m_Max);
      cam.m_PointOfView = cam.m_LookAt - Ark::Vector3 (0.0, 0.0, box.m_Max.Z+fact);
      cam.m_FOV = 60.0;

      modelview_SetLight(cam.m_PointOfView);
      m_Renderer->SetCamera(cam);

      m_ModelState.ComputeMatrix();
      m_ModelState.Render(*m_Renderer);
   }

   m_Timer.Update();
   return true;
}

void
GLModelView::SetModel(const std::string& name)
{
   m_ModelState = Ark::ModelState();
   m_ModelState.SetModel(&m_Renderer->GetCache(), name);
   m_ModelState.Play(Ark::ModelState::LOOP, "walk");

   std::cerr << name << std::endl;
   return;
}


