/*

  typedef.h - Data structures for use with grinder

*/

/* $Id: typedef.h,v 1.11 2001/09/06 17:55:38 wn Rel $ */

#ifndef _TYPEDEF_
#define _TYPEDEF_
#ifndef _WNCONSTS_
#include "wnconsts.h"
#endif

/* Structure for representing a synset */

typedef struct synset {
    struct synset *ssnext;	/* next synset */
    struct synset *fans;	/* if adjective cluster head, list of fans
				   if fan, pointer to cluster head */
    struct synonym *syns;	/* list of synonyms in synset */
    struct pointer *ptrs;	/* list of pointers from this synset */
    struct framelist *frames;	/* for verbs - list of framelists */
    char *defn;			/* textual gloss (optional) */
    unsigned int key;		/* unique synset key */
    unsigned char part;		/* part of speech */
    unsigned char isfanss;	/* TRUE - synset is fan synset */
    unsigned char filenum;	/* file number (from cmdline) synset is in */
    int clusnum;		/* cluster # if synset is part of cluster */
    int lineno;			/* line number in file of synset */
    long filepos;		/* byte offset of synset in output file */
} Ss, *Synset;

/* A pointer from one synset to another */

typedef struct pointer {
    struct pointer *pnext;	/* next pointer from synset */
    struct symbol *pword;	/* word used to identify target synset */
    struct symbol *pslite;	/* label of satellite pointed to (optional) */
    struct synset *psynset;	/* target synset */
    unsigned char pfilenum;	/* file containing target synset */
    unsigned char psensenum;	/* sense number of word */
    unsigned char pslite_sense; /* sense number of satellite (optional) */
    unsigned char phead;	/* TRUE - pointer is to cluster head word */
    unsigned char ptype;	/* pointer type */
    unsigned char status;	/* status of pointer */
    short fromwdnum;		/* word number in this synset ptr is from */
    short towdnum;		/* word number in target synset ptr is to */
} Ptr, *Pointer;

/* Verb frame list */

typedef struct framelist {
    struct framelist *fnext;	/* next framelist */
    unsigned long frames[(NUMFRAMES/32) + 1]; /* bits for verb frames */
    unsigned char frwdnum;	/* word number that frame list is for */
} Fr, *Framelist;

/* A word in a synset */

typedef struct synonym {
    struct synonym *synnext;	/* next word in synset */
    struct synset *ss;		/* synset this synonym is in */
    struct symbol *word;	/* symbol table entry for word string */
    short sswdnum;		/* word number in synset ( <0, headword ) */
    short tagcnt;		/* num times sense is tagged in concordance */
    unsigned char wnsensenum;	/* sense number in wn database */
    unsigned char sensenum;	/* sense number in lexicographer's file */
    unsigned char adjclass;	/* adjective class of word */
    unsigned char infanss;	/* TRUE - synonym is in fan synset */
				/* FALSE - synonym is not in fan */
    char *label;		/* only used if string is not lowercase
				   if lowercase, use word->label */
} Syn, *Synonym;

/* Structure for storing word strings */

typedef struct symbol {
    struct symbol *symnext;	/* next symbol in this slot */
    struct synlist *syns;	/* uses of this word as a synonym */
    unsigned char sensecnt[NUMPARTS + 1]; /* senses for all parts of speech */
    char *label;		/* word */
} Sym, *Symbol;

/* List of use of this word as a synonym */

typedef struct synlist {
    struct synlist *snext;	/* next item on synonym list */
    struct synonym *psyn;	/* pointer to synonym structure */
} Synl, *SynList;

#endif				/* _TYPEDEF_ */

/*
  Revision log:

  $Log: typedef.h,v $
  Revision 1.11  2001/09/06 17:55:38  wn
  added code for synset keys

  Revision 1.10  1997/08/05 14:23:46  wn
  added function prototypes, other small cleanups

 * Revision 1.9  1994/03/24  09:53:41  wn
 * *** empty log message ***
 *
 * Revision 1.8  94/03/03  11:55:34  wn
 * added tagcnt field to synonym structure
 * 
 * Revision 1.7  92/08/19  16:01:17  wn
 * added pslite and pslite_sense to Pointer structure
 * 
 * Revision 1.6  92/02/18  16:54:19  wn
 * changed wdnum fields from unsigned char to short
 * 
 * Revision 1.5  91/12/13  17:10:44  wn
 * no changes
 * 
 * Revision 1.4  91/12/13  15:53:44  wn
 * changed some defines to use ones in wnconsts.h
 * 
 * Revision 1.3  91/10/30  13:28:11  wn
 * removed ssprev since it isn't used
 * 
 * Revision 1.2  91/09/25  14:22:45  wn
 * added label field to synonym structure
 * 
 * Revision 1.1  91/09/11  14:46:24  wn
 * Initial revision
 * 
*/
