/* $Id: utils.c,v 2.1 1998/09/19 03:31:24 sgifford Exp $ */

/* Utility functions. */

/*
    Copyright (C) 1998  Scott Gifford

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    If you have any questions, comments, or compliments, feel free to contact
    me at <sgifford@tir.com>.
*/

#include <stdio.h>
#include <stdlib.h>
#include <strings.h>
#include <stdarg.h>
#include "utils.h"

int cur_debuglevel;

void *die(char *message)
{
  fputs(message,stderr);
  fputs("\n",stderr);
  exit(1);
}

void *safe_realloc(void *ptr, size_t size)
{
  char *result;

  if (!(result=realloc(ptr,size)))
    die("Out of memory during realloc!");
  return result;
}

void *safe_malloc(size_t size)
{
  char *result;

  if (!(result=malloc(size)))
    die("Out of memory during malloc!");
  return result;
}

char *safe_strdup(const char *s)
{
  char *result;

  if (!(result=strdup(s)))
    die("Out of memory during strdup!");
  return result;
}

void *free_if_used(void *ptr)
{
  if(ptr)
    free(ptr);

  return ptr;
}

void debuglevel(int i)
{
  cur_debuglevel=i;
}

void debug(int lev, const char *fmt, ...)
{
  va_list  args;
	
  if (cur_debuglevel >= lev)
  {
    va_start(args,fmt);
    vprintf(fmt,args);
    va_end(args);
  }
}
