//
//  The Worldforge Project
//  Copyright (C) 2004 The Worldforge Project
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU Lesser General Public License as 
//  published by the Free Software Foundation; either version 2.1 of the
//  License, or (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, SA.
//
//  For information about Worldforge and its authors, please contact
//  the Worldforge Web Site at http://www.worldforge.org.
//

// Written by Ron Steinke, 01/2004

#ifndef WFTK_DEBUG_TIMER_H
#define WFTK_DEBUG_TIMER_H

#include <wftk/debug.h>
#ifdef DEBUG
#include <wftk/timer.h>
#endif

namespace wftk {

class DebugTimer
{
 public:
  DebugTimer(const Debug& out, unsigned threshold = 2) :
	out_(out), threshold_(threshold) {set();}

  void set()
  {
#ifdef DEBUG
    if(out_)
      time_ = Time::now();
#endif
  }

  void mark(const std::string& msg, const std::string& post = "")
  {
    unsigned passed = check();
    if(passed >= threshold_)
      out_ << msg << " took " << passed << " ms " << post << Debug::endl;
  }

  // for custom versions of mark()
  unsigned check()
  {
#ifdef DEBUG
    if(out_) {
      Time next = Time::now();
      unsigned passed = next - time_;
      time_ = next;
      return passed;
    }
    else
#endif
      return 0;
  }

 private:
#ifdef DEBUG
  Time time_;
#endif
  Debug out_;
  unsigned threshold_;
};

} // namespace

#endif // WFTK_DEBUG_TIMER_H
