#!/usr/local/bin/perl
# Backup servers from the command line

$no_acl_check++;
$ENV{'WEBMIN_CONFIG'} ||= "/etc/webmin";
$ENV{'WEBMIN_VAR'} ||= "/var/webmin";
if ($0 =~ /^(.*\/)[^\/]+$/) {
	chdir($1);
	}
chop($pwd = `pwd`);
$0 = "$pwd/restore-domain.pl";
require './virtual-server-lib.pl';
$< == 0 || die "restore-domain.pl must be run as root";

$first_print = \&first_text_print;
$second_print = \&second_text_print;
$indent_print = \&indent_text_print;
$outdent_print = \&outdent_text_print;

# Parse command-line args
while(@ARGV > 0) {
	local $a = shift(@ARGV);
	if ($a eq "--dest") {
		$dest = shift(@ARGV);
		}
	elsif ($a eq "--feature") {
		local $f = shift(@ARGV);
		$config{$f} || die "Feature $f is not enabled";
		push(@bfeats, $f);
		}
	elsif ($a eq "--domain") {
		push(@bdoms, shift(@ARGV));
		}
	elsif ($a eq "--all-features") {
		@bfeats = grep { $config{$_} } @backup_features;
		}
	elsif ($a eq "--all-domains") {
		$all_doms = 1;
		}
	elsif ($a eq "--test") {
		$test = 1;
		}
	elsif ($a eq "--ignore-errors") {
		$ignore_errors = 1;
		}
	elsif ($a eq "--separate") {
		$separate = 1;
		}
	else {
		&usage();
		}
	}
$dest || usage();
@bdoms || $all_doms || usage();
@bfeats || usage();

# Work out what will be backed up
if ($all_doms) {
	@doms = &list_domains();
	}
else {
	foreach $dname (@bdoms) {
		local $dinfo = &get_domain_by("dom", $dname);
		push(@doms, $dinfo) if ($dinfo);
		}
	}

if ($test) {
	# Just tell the user what will be done
	print "The following servers will be backed up :\n";
	foreach $d (@doms) {
		print "\t$d->{'dom'}\n";
		}
	print "\n";
	print "The following features will be backed up :\n";
	foreach $f (@bfeats) {
		$fn = $text{"backup_feature_".$f} || $text{"feature_".$f};
		print "\t",($fn ? $fn." ($f)" : $f),"\n";
		}
	exit(0);
	}

# Do the backup, printing any output
&$first_print("Starting backup..");
($ok, $size) = &backup_domains($dest, \@doms, \@bfeats,
			       $separate,
			       $ignore_errors);
if ($ok) {
	&$second_print("Backup completed successfully. Final size was ".
		       &nice_size($size));
	}
else {
	&$second_print("Backup failed!");
	}

sub usage
{
print "Creates a Virtualmin backup, for the domains and features specified\n";
print "on the command line.\n";
print "\n";
print "usage: backup-domain.pl --dest file\n";
print "                  [--test]\n";
print "                  [--domain name] | [--all-domains]\n";
print "                  [--feature name] | [--all-features]\n";
print "                  [--ignore-errors]\n";
print "                  [--separate]\n";
print "\n";
print "Multiple domains may be specified with multiple --domain parameters.\n";
print "Features must be specified using their short names, like web and dns.\n";
exit(1);
}

