#!/usr/bin/perl
#
# snort-lib.pl - common routines for the snort Webmin inerface

# Grab common webmin routines and initialize
do '../web-lib.pl';
&init_config("snort");

# Grab access rules
%access = &get_module_acl();

# std_setting($name, $setting, $de_choice, $enabled)
#
# returns HTML to include on a Webmin form based on the info passed
# Note it will also include table tags as options will be rows within a table

sub std_setting() {

   local $n = $_[0];
   local ($prt_name) = split('__', $n);
   print "<tr $cb><td><b>$prt_name</b><td><input type=\"text\" name=\"$n\" value=\"" . &html_escape($_[1]) . "\" size=60>\n";
   if ($_[2]) {
      printf "<td align=right><input type=radio name=${n}_stat value=1 %s> %s$text{'index_enabled'}%s\n",
        $_[3] ? "checked" : "", $_[3] ? "<b><font color=\"#006600\">" : "", $_[3] ? "</b></font>" : "";
      printf "<input type=radio name=${n}_stat value=0 %s> %s$text{'index_disabled'}%s</td>\n",
        $_[3] ? "" : "checked", $_[3] ? "" : "<b><font color=\"#CC0000\">", $_[3] ? "" : "</b></font>";
   } else {
      print "<td>&nbsp;</td>\n";
   }
}


# get_config($type)
#
# Get the current configuration
# Configuration info is stored in an array of hashes
# We only return data of a specific type (passed in)
#
# As of Snort 1.8, those types are
#   var (Network Variables)
#   pre (Preprocessors)
#   out (Output config)
#   rule (Rule Includes)
#
# Each array element is a pointer to a hash for each element
#
# name -> Name of setting (or rule file in case of rules)
# value -> Value for setting (empty if rule)
# line -> Line number in file of this setting
# index -> position in list
# disabled -> set true if setting is commented out
#

sub get_config {
   local($type) = @_;
   local($lnum, $idx, %rv);
   local($comm, $name, $value);

   $lnum = 0;
   $idx = 0;

   open(FILE, $config{'snort_config'}) || &snort_error($text{'lib_config_notfound'}, " ", $config{'snort_config'}, ": ", $@);
   while($line = <FILE>) {
      $comm = ""; $name = ""; $value = "";
      $line =~ s/\r|\n//g;   # strip out newlines
      $line =~ s/\s+$//;     # strip trailing spaces
      
      # if we hit a ruletype, lets skip it to avoid grabbing the innards
      if ($line =~ /ruletype\s+\w+/) { 
         do { 
            $tline = <FILE>; 
            $lnum++;
         } while ($tline !~ /}/); 
      }

      # Parse the setting based on teh setting type we are looking for
      $match = 0;
      if ($type eq 'var') {
         # The format of these lines is var 'var name' 'var value'
         # Note we do NOT allow var settings to be commented - otherwise we pick up
         # The example ones above the actual settings.
         $match = 1 if (($name, $value) = $line =~ /^var\s+(\S+)\s*(.*)$/); 
#         $match = 1 if (($comm, $name, $value) = $line =~ /^([#]*)\s*var\s*([a-zA-Z_0-9\-]+)[:]*\s*(.*)$/); 
      } elsif ($type eq 'pre') {
         # The format of these lines is preprocessor (proc name) and optional settings following an optional :
         $match = 1 if (($comm, $name, $value) = $line =~ /^([#]*)\s*preprocessor\s*([a-zA-Z_0-9\-]+)[:]*\s*(.*)$/); 
      } elsif ($type eq 'out') {
         # The format of these lines is output 'out name': output settings
         $match = 1 if (($comm, $name, $value) = $line =~ /^([#]*)\s*output\s*([a-zA-Z_0-9\-]+)[:]*\s*(.*)$/); 
      } elsif ($type eq 'rule') {
         # The format of these lines is include (rulset name).rules
         $match = 1 if (($comm, $name, $value) = $line =~ /^([#]*)\s*include\s+(\S+)\.rules$/); 
      } else {
         # If we ever get here there is a problem
         close(FILE);
         &snort_error($text{'lib_config_unknown_type'}, ": ", $type);
      }

      if ($match) {
         # We found a valid setting
         local(%dir);
         if ($comm) { $dir{'disabled'} = 1; }  # Flag if the setting is commented out
         $dir{'value'} = $value;
         $dir{'line'} = $lnum;
         $dir{'index'} = $idx++;

         # A user MIGHT have duplicates of an item name in comments - if htey do, add increment #
         $name .= "__" . $idx if ($rv{$name});
         $rv{$name} = {%dir};
      }     

      $lnum++;
   } # while($line = <FILE>) {
   close(FILE);

   return \%rv;
}


sub snort_error {
   &header($text{'error'}, "");
   print "<hr>\n<h3>",($whatfailed ? "$whatfailed : " : ""),join(" ", @_),"</h3>\n<hr>\n";
   &footer("index.cgi", $text{'back_link'});
   exit;
}

1;

