#ifndef GVT_MANAGER_FACTORY_H
#define GVT_MANAGER_FACTORY_H

// Copyright (c) The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.

// Authors: Malolan Chetlur             mal@ececs.uc.edu
//          Jorgen Dahl                 dahlj@ececs.uc.edu
//          Dale E. Martin              dmartin@cliftonlabs.com
//          Radharamanan Radhakrishnan  ramanan@ececs.uc.edu
//          Dhananjai Madhava Rao       dmadhava@ececs.uc.edu
//          Philip A. Wilsey            phil.wilsey@uc.edu

#include "warped.h"
#include "GVTManager.h"
#include "SimulationManager.h"
#include "Configurer.h"

/** The GVTManagerFactory class.

    This is the  factory interface for the various GVT
    Estimation Algorithm implementations in the Simulation kernel. The
    specific gvt estimation implementation is hidden from the other
    components of the simulation kernel by the aggregation of the
    different implemetations in this class interface ( factory
    pattern).  All gvt estimation implementations must however be
    derived from the GVTManager abstract base class.

*/
class GVTManagerFactory : virtual public Configurer {
public:

  /**@name Public Class Methods of GVTManagerFactory. */
  //@{

  /// Constructor.
  GVTManagerFactory();

  /// Destructor
  virtual ~GVTManagerFactory();

  /** Configures the GVT manager.

  @param configurationMap The set of configuration options set.
  */
  Configurable *allocate( SimulationConfiguration &configuration,
			  Configurable *parent ) const;

  static const GVTManagerFactory *instance();
   
  //@} // End of Public Class Methods of GVTManagerFactory.

private:

  /**@name Private Class Attributes of GVTManagerFactory. */
  //@{
   
  //@} // End of  Private Class Attributes of GVTManagerFactory.
   
};

#endif
