/* -*- C++ -*-
   
  This file is part of ViPEC
  Copyright (C) 1991-2000 Johan Rossouw (jrossouw@alcatel.altech.co.za)
 
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU Library General Public License as
  published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 
*/

#include <TableFrame.h>

#include <GraphView.h>

#include <iostream>

//----------------------------------------------------------------------------
TableFrame::TableFrame(GraphView& parent, const char *name )
    : QTable(&parent, name),
    view_(parent)
{
  curRow_ = curCol_ = 0;		// set currently selected cell
  setFocusPolicy( StrongFocus );	// we accept keyboard focus
  setBackgroundMode( PaletteBase );    	// set widgets background
  setReadOnly(TRUE);
}

//----------------------------------------------------------------------------
TableFrame::~TableFrame()
{}

//----------------------------------------------------------------------------
void TableFrame::drawContents( QPainter* p )
{
  view_.draw( p );
}

//----------------------------------------------------------------------------
void TableFrame::reDraw()
{
  view_.draw( 0 );
}

//----------------------------------------------------------------------------
void TableFrame::setSize( int rows, int cols )
{
  QTable::setNumCols( cols );
  QTable::setNumRows( rows );
}

//----------------------------------------------------------------------------
void TableFrame::setHeader( int col, const QString& text )
{
  QHeader *header = horizontalHeader();
  header->setLabel( col, text );
}

//----------------------------------------------------------------------------
void TableFrame::setRowHeader( int row, const QString& text )
{
  QHeader *header = verticalHeader();
  header->setLabel( row, text );
}

//----------------------------------------------------------------------------
void TableFrame::setCell( int row, int col, const QString& text )
{
  setText( row-1, col-1, text);
}

//----------------------------------------------------------------------------
int TableFrame::indexOf( int row, int col ) const
  {
    return (row * numCols()) + col;
  }

