/* ==================================================== ======== ======= *
 *
 *  uuprop.cpp
 *  Ubit Project  [Elc][2003]
 *  Author: Eric Lecolinet
 *
 *  Part of the Ubit Toolkit: A Brick Construction Game Model for Creating GUIs
 *
 *  (C) 1999-2003 Eric Lecolinet @ ENST Paris
 *  WWW: http://www.enst.fr/~elc/ubit   Email: elc@enst.fr (subject: ubit)
 *
 * ***********************************************************************
 * COPYRIGHT NOTICE : 
 * THIS PROGRAM IS DISTRIBUTED WITHOUT ANY WARRANTY AND WITHOUT EVEN THE 
 * IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. 
 * YOU CAN REDISTRIBUTE IT AND/OR MODIFY IT UNDER THE TERMS OF THE GNU 
 * GENERAL PUBLIC LICENSE AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
 * EITHER VERSION 2 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
 * SEE FILES 'COPYRIGHT' AND 'COPYING' FOR MORE DETAILS.
 * ***********************************************************************
 *
 * ==================================================== [Elc:O2] ======= *
 * ==================================================== ======== ======= */

//pragma ident	"@(#)uuprop.cpp	ubit:03.06.03"
#include <iostream>
#include <udefs.hpp>
#include <ubrick.hpp>
#include <ucond.hpp>
#include <ucall.hpp>
#include <uprop.hpp>
#include <uctrl.hpp>
#include <ucontext.hpp>
#include <uview.hpp>
#include <ubox.hpp>
#include <ucolor.hpp>
#include <ucall.hpp>
#include <uevent.hpp>
#include <update.hpp>
#include <ustr.hpp>
using namespace std;

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */

void UProp::onChange(UCall &c) {
  addChangeCall(c);
}

void UProp::changed(bool update_now) {
  if (update_now && (bmodes & UMode::NO_AUTO_UPDATE) == 0)
    update();

  // faux: parent pas notifie si pas de CB sur ustr !!!
  //  if (cache) {  !!!

  UEvent e(UEvent::change,  null, null, NULL);
  e.setAux(this);

  if (cache) fire(e, UOn::change);

  // ensuite on lance les callbacks des parents
  parents.fireParents(e, UOn::propChange);
}

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */

UScale::UScale(int _value) : UIntgBase(_value) {}
UScale::UScale(const UIntgBase& _value) : UIntgBase(_value) {}

float UScale::getXScale() const {
  return UFontFamily::getXYScale(getValue());
}

float UScale::getYScale() const {
  return UFontFamily::getXYScale(getValue());
}

void  UScale::getXYScale(float& xscale, float& yscale) const {
  xscale = yscale = UFontFamily::getXYScale(getValue());
}

float UScale::getXScale(int lscale) {
  return UFontFamily::getXYScale(lscale);
}

float UScale::getYScale(int lscale) {
  return UFontFamily::getXYScale(lscale);
}

void  UScale::getXYScale(int lscale, float& xscale, float& yscale) {
  xscale = yscale = UFontFamily::getXYScale(lscale);
}

// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

void UScale::putProp(UContext *props, UCtrl *state) {
  if (getValue() != 0) {
    //NB: lscale = LOGICAL scale
    props->lscale += getValue();	// += c'est en relatif !
    props->fontdesc.incrScale(getValue());
    props->xyscale = UFontFamily::getXYScale(props->lscale);
  }
}

void UScale::changed(bool update_now) {
  //cerr << "UScale::changed" << endl;
UProp::changed(true);
}

void UScale::update() {
  //parents.updateParents(UUpdate::win);
  parents.updateParents(UUpdate::all);
}

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */

UAlpha::UAlpha(float val) : UProp() {
  value = val;
}

void UAlpha::set(float val) {
  if (value == val) return;
  value = val;
  changed(true);
}
void UAlpha::set(float val, bool upd) {
  if (value == val) return;
  value = val;
  changed(upd);
}

void UAlpha::update() {
  parents.updateParents(UUpdate::paint);
}

void UAlpha::putProp(UContext *props, UCtrl *state) {
  props->local.alpha = value;
}

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */

UBackground& ubackground(const UColor &bgcolor) {
  return *(new UBackground(bgcolor));
}

UBackground& ubackground(const UIma &bgima) {
  return *(new UBackground(bgima));
}

UBackground::UBackground() : UProp() {
  bgima   = null;
  bgcolor = null;
  halign  = null;
  valign  = null;
}
UBackground::UBackground(const UIma &_bgima) : UProp() {
  bgima   = &_bgima;
  bgcolor = null;
  halign  = null;
  valign  = null;
}
UBackground::UBackground(const UColor& _bgcolor) : UProp() {
  bgima   = null;
  bgcolor = &_bgcolor;
  halign  = null;
  valign  = null;
}

void UBackground::set(const UIma& _bgima, const UColor& _bgcolor) {
  if (bgcolor && bgcolor->equals(_bgcolor) && bgima == &_bgima) 
    return;
  bgima   = &_bgima;
  bgcolor = &_bgcolor;
  changed(true);
}

void UBackground::set(const UIma& _bgima) {
  if (bgima == &_bgima 
      && (bgcolor == null || bgcolor->equals(UBgcolor::none)))
    return;
  bgima   = &_bgima;
  bgcolor = null;
  changed(true);
}

void UBackground::set(const UColor& _bgcolor) {
  if (bgcolor && bgcolor->equals(_bgcolor) && bgima == null) 
    return;
  bgima   = null;
  bgcolor = &_bgcolor;
  changed(true);
}

void UBackground::setLayout(const UHalign& ha, const UValign& va) {
  halign = &ha;
  valign = &va;
}

void UBackground::update() {
  parents.updateParents(UUpdate::paint);
}
void UBackground::putProp(UContext *props, UCtrl*){
  props->local.background = this;
}

/* ==================================================== [Elc:01] ======= */
/* ==================================================== ======== ======= */
/*
UShape& ushape(UPix &pix) {
  return *(new UShape(pix));
}

UShape::UShape(const UPix &_pix, u_modes m) : UProp(m){
  pix = &_pix;
}

void UShape::set(const UPix *_pix) {
  if (pix == _pix) return;
  pix = _pix;
  changed(true);
}
void UShape::set(const UPix &_pix) {set(&_pix);}

void UShape::update(){
  parents.updateParents(UUpdate::all);
}
void UShape::putProp(UContext *props, UCtrl*){
  props->local.shape = this;
}
*/
/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */

UOrient UOrient::vertical(VERTICAL, UMode::UCONST);
UOrient UOrient::horizontal(HORIZONTAL, UMode::UCONST);
UOrient UOrient::inherit(INHERIT, UMode::UCONST);

UOrient& uorient(const UOrient& _o) {return *(new UOrient(_o));}

UOrient::UOrient(const UOrient &_o) : UProp() {
  value = _o.value;
}
// ce constructeur est reserve a l'usage interne
UOrient::UOrient(char val, u_modes bm) : UProp(bm) {
  value = val;
}

void UOrient::set(const UOrient &o) {
  if (value == o.value) return;
  value = o.value; //if (upd) update();
  changed(true);
}

void UOrient::update() {
  UUpdate upd(UUpdate::SHOW);
  parents.updateParents(upd);
}

void UOrient::putProp(UContext* props, UCtrl* state) {
  //props->orient = value;

  // nb: inherited => ne fait rien // !new
  if (value == VERTICAL) 
    state->setBmodes(UMode::IS_VERTICAL, true);
  else if (value == HORIZONTAL)
    state->setBmodes(UMode::IS_VERTICAL, false);
}

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */

UValign UValign::top(TOP, UMode::UCONST);
UValign UValign::bottom(BOTTOM, UMode::UCONST);
UValign UValign::center(CENTER, UMode::UCONST);
UValign UValign::flex(FLEX, UMode::UCONST);

UValign& uvalign(const UValign &o) {
  return *(new UValign(o));
}

// NB: must be UProp because flex is propagated to direct children
UValign::UValign(const UValign &o) : UProp() {
  value = o.value;
}

// ce constructeur est reserve a l'usage interne
UValign::UValign(char val, u_modes bm): UProp(bm){
  value = val;
}

void UValign::set(const UValign &obj) {
  if (value == obj.value) return;
  value = obj.value;
  changed(true);
}

void UValign::update() {
  // box size won't change but children layout must be updated
  parents.updateParents(UUpdate::all);
}

void UValign::putProp(UContext *props, UCtrl *state) {
  props->local.valign = value;
}

/* ==================================================== [Elc:98] ======= */
/* ==================================================== ======== ======= */

UHalign UHalign::left(LEFT, UMode::UCONST);
UHalign UHalign::right(RIGHT, UMode::UCONST);
UHalign UHalign::center(CENTER, UMode::UCONST);
UHalign UHalign::flex(FLEX, UMode::UCONST);

UHalign& uhalign(const UHalign &o) {
  return *(new UHalign(o));
}

// NB: must be UProp because flex is propagated to the direct child
UHalign::UHalign(const UHalign &o) : UProp() {
  value = o.value;
}

// ce constructeur est reserve a l'usage interne
UHalign::UHalign(char val, u_modes bm): UProp(bm){
  value = val;
}

void UHalign::set(const UHalign &o) {
  if (value == o.value) return;
  value = o.value;
  changed(true);
}

void UHalign::update() {
  // box size won't change but children layout must be updated
  parents.updateParents(UUpdate::all);
}

void UHalign::putProp(UContext *props, UCtrl *state) {
  props->local.halign = value;
}

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */

//UHmargin UHmargin::none(0);
//UHmargin UHmargin::one(1);
//UHmargin UHmargin::two(2);

UHmargin& uhmargin(int val) {
  return *(new UHmargin(val));
}

UHmargin::UHmargin(int val): UProp() {
  value = val;
}

void UHmargin::set(int val) {
  if (value == val) return;
  value = val; 
  changed(true);
}

void UHmargin::update() {
  parents.updateParents(UUpdate::all);
}

void UHmargin::putProp(UContext *props, UCtrl *state) {
  props->local.padding.left = props->local.padding.right = value;
}

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */

//UVmargin UVmargin::none(0);
//UVmargin UVmargin::one(1);
//UVmargin UVmargin::two(2);

UVmargin& uvmargin(int val) {
  return *(new UVmargin(val));
}

UVmargin::UVmargin(int val) : UProp() {
  value = val;
}

void UVmargin::set(int val) {
  if (value == val) return;
  value = val;
  changed(true);
}

void UVmargin::update() {
  parents.updateParents(UUpdate::all);
}

void UVmargin::putProp(UContext *props, UCtrl *state) {
  props->local.padding.top = props->local.padding.bottom = value;
}

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */

//UHspacing UHspacing::none(0);
//UHspacing UHspacing::one(1);
//UHspacing UHspacing::two(2);

UHspacing& uhspacing(int val) {
  return *new UHspacing(val);
}

UHspacing::UHspacing(int val) : UProp() {
  value = val;
}

void UHspacing::set(int val) {
  if (value == val) return;
  value = val;
  changed(true);
}

void UHspacing::update() {
  parents.updateParents(UUpdate::all);
}

void UHspacing::putProp(UContext *props, UCtrl *state) {
  props->local.hspacing = value;
}

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */

//UVspacing UVspacing::none(0);
//UVspacing UVspacing::one(1);
//UVspacing UVspacing::two(2);

UVspacing& uvspacing(int val) {
  return *(new UVspacing(val));
}

UVspacing::UVspacing(int val) : UProp() {
  value = val;
}

void UVspacing::set(int val) {
  if (value == val) return;
  value = val;
  changed(true);
}

void UVspacing::update() {
  parents.updateParents(UUpdate::all);
}

void UVspacing::putProp(UContext *props, UCtrl *state) {
  props->local.vspacing = value;
}

/* ==================================================== [Elc:01] ======= */
/* ==================================================== ======== ======= */
// Usage:
// -- uwidth(int) with int >= 0  : size fixed by argument.
//    horizontal size won't change except if the box is uhflex()
// -- uwidth(UWidth::keepSize)   : keep initial size.
//    size is computed automatically the first time, then does not change.
// -- uwidth(UWidth::autoResize) : size automatically adapts
//    size is re-computed automatically each time

const u_dim UWidth::AUTO_RESIZE  = -2;
const u_dim UWidth::KEEP_SIZE = -1;


UWidth& uwidth(u_dim val) {return *(new UWidth(val));}

UWidth::UWidth(u_dim val) {value = val;}
UWidth::UWidth(const UWidth& val) {value = val.value;}

void UWidth::set(u_dim val) {
  if (value == val) return;
  value = val;
  changed(true);
}

void UWidth::update() {
  parents.updateParents(UUpdate::all);
}

void UWidth::putProp(UContext *props, UCtrl*) {
  props->local.width = value;
}

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */
// Usage:
// -- same as UWidth (see above)

const u_dim UHeight::AUTO_RESIZE  = -2;
const u_dim UHeight::KEEP_SIZE = -1;

UHeight& uheight(u_dim val) { return *(new UHeight(val));}

UHeight::UHeight(u_dim val) {value = val;}
UHeight::UHeight(const UHeight& val) {value = val.value;}

void UHeight::set(u_dim val) {
  if (value == val) return;
  value = val;
  changed(true);
}

void UHeight::update() {
  parents.updateParents(UUpdate::all);
}

void UHeight::putProp(UContext *props, UCtrl*) {
  props->local.height = value;
}

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */

UPos::UPos() : UProp(), x(0), y(0) {}

UPos::UPos(u_pos _x, u_pos _y) : UProp(), x(_x), y(_y) {}

UPos::UPos(const UPos& p) : UProp(), x(p.x), y(p.y) {}

void UPos::addingTo(ULink *selflink,  UGroup *parent) {
  UProp::addingTo(selflink, parent);

 if (parent->isDef(0, UMode::HAS_RENDERER)) {
   UError::error("warning@UPos::addingTo", 
		 "multiple UPos bricks in object: ", parent->cname());
 }
 
  // rendre parent sensitif aux events ad hoc
  parent->setCmodes(UMode::FLOATING, true);
}

void UPos::removingFrom(ULink *selflink, UGroup *parent) {
  parent->setCmodes(UMode::FLOATING, false);
  UProp::removingFrom(selflink, parent);
}

/* ==================================================== ======== ======= */

UPos& UPos::operator=(const UPos& p) {
	set(p.x, p.y, true); return *this;
}
void UPos::set(const UPos& p, bool update_now) {
	set(p.x, p.y, update_now);
}
void UPos::setX(u_pos _x)  {set(_x, y, true);}
void UPos::setY(u_pos _y)  {set(x, _y, true);}
//void UPos::set(u_pos _x, u_pos _y) {set(_x,_y,true);}

void UPos::set(u_pos _x, u_pos _y, bool update_now) {
  //cerr << "upos::set x: " << x << " - _x: "<< _x <<endl;
  if (x == _x && y == _y) return;

  if (!update_now) {
    x = _x;
    y = _y;
  }
  else {
    UUpdate upd(UUpdate::MOVE);
    upd.setOffset(_x - x, _y - y);
    x = _x;
    y = _y;

    // NB: double buffering fait dans UBox::updateView cas MOVE
    // UNIQUEMENT si la view est TRANSPARENTE

    // il faut d'ABORD mettre le champ OBS_COORDS a true
    // sur TOUTES les vues PUIS faire updateParent
    // *Raison:
    // il est necessaire de savoir QUAND les coords d'une view
    // sont a jour et qunad elles ne le sont pas, d'ou ces deux phases:
    // -1) setModesOfParentViews active le flag OBS_COORDS
    //     de toutes les vues concernees pour indiquer que leurs
    //     coords ne sont plus a jour
    // -2) UView::doUpdate/setCoords remet les coords a jour 
    //     et annule ce flag
    // *Note:
    // ce flag est en particulier indispensable pour UBox::updateView
    // dans le cas MOVE, pour savoir si view.x/y sont les anciennes
    // ou nouvelles coords

    parents.setModesOfParentViews(UView::OBS_COORDS, true);
    parents.updateParents(upd);
  }

  changed(false); //upd deja fait si requis ???
}

void UPos::update()  {
  //hum, c'est pas le layout qui change mais la position...!
  parents.updateParents(UUpdate::all);
}

void UPos::putProp(UContext *props, UCtrl *state) {
  props->local.xpos = x;
  props->local.ypos = y;
}

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */

UTip::UTip(const char* _s) : value(new UStr(_s)) {}

UTip::UTip(UStr& _val) : value(_val) {
  //value->onChange(ucall(this, true, &UTip::changed)); compile pas avec CC
  value->onChange(ucall(this, true, &UProp::changed));
}

void UTip::set(const UStr& _val) {
  if (value->equals(_val)) return;
  value->set(_val);
  changed(true);    // pbm: appele 2 fois si UTip(UStr& _val)
}

void UTip::update() {}

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */

UTitle::UTitle(const char* _s) : value(new UStr(_s)) {}

UTitle::UTitle(const UStr& _val) : value(new UStr(_val)) {}

UTitle::UTitle(UStr& _val) : value(_val) {
  //value->onChange(ucall(this, true, &UTitle::changed));compile pas avec CC
  value->onChange(ucall(this, true, &UProp::changed));
}

void UTitle::set(const UStr& _val) {
  if (value->equals(_val)) return;
  value->set(_val);
  changed(true);    // pbm: appele 2 fois si UTip(UStr& _val)
}

void UTitle::update() {
  //cerr<< "title update \n";
  UUpdate upd(UUpdate::TITLE);
  upd.paintTitle(value);
  parents.updateParents(upd);
}

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */

UComment& ucomment(const char*str) {return *(new UComment(str));}

UComment::UComment(const char* str) : UProp() {
  value = CStr::strdup(str);
}

// can resize if val >= 0 / can't resize if val < 0
void UComment::set(const char* str) {
  if (value == str) return;
  if (value) free(value);
  value = CStr::strdup(str);
  changed(false);
}

void UComment::update() {
  //parents.updateParents(UUpdate::all);
}

void UComment::putProp(UContext *props, UCtrl*) {
  //props->local.wrap = value;
}

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */

UFlagdef::UFlagdef() : flag(null) {}

UFlagdef::UFlagdef(const UFlag& _f) : flag(&_f) {}

void UFlagdef::set(const UFlag& _f) {
  // test equals ???
  flag = &_f;
  update();
}

void UFlagdef::clear() {
  flag = null;
  update();
}

void UFlagdef::update() {
  parents.updateParents(UUpdate::all);
}

void UFlagdef::putProp(UContext *ctx, UCtrl *state) {
  if (flag && flag != &UFlag::none)
    ctx->addFlagdef(this);
}

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */

UPropdef::UPropdef() : UFlagdef(), prop(null) {}

UPropdef::UPropdef(const UFlag& _f) : UFlagdef(_f), prop(null) {}

UPropdef::UPropdef(const UFlag& _f, UProp& _p) : UFlagdef(_f), prop(&_p) {}

UPropdef::UPropdef(const UFlag& _f, UProp* _p) : UFlagdef(_f), prop(_p) {}

UPropdef& upropdef(const class UFlag& _f, UProp& _p) {
  return *new UPropdef(_f, _p);
}
UPropdef& upropdef(const class UFlag& _f, UProp* _p) {
  return *new UPropdef(_f, _p);
}

/* ==================================================== ======== ======= */

void UPropdef::set(const UFlag& _f) {
  // test equals ???
  flag = &_f;
  update();
}

void UPropdef::set(UProp& _p) {
  // test equals ???
  prop = _p;
  update();
}

void UPropdef::set(UProp* _p) {
  // test equals ???
  prop = _p;
  update();
}

void UPropdef::set(const UFlag& _f, UProp& _p) {
  // test equals ???
  flag = &_f;
  prop = _p;
  update();
}

void UPropdef::set(const UFlag& _f, UProp* _p) {
  // test equals ???
  flag = &_f;
  prop = _p;
  update();
}

void UPropdef::clear() {
  flag = null;
  prop = null;
  update();
}

void UPropdef::putProp(UContext *ctx, UCtrl *state) {
  if (prop && flag && flag != &UFlag::none)
    ctx->addFlagdef(this);
}

/* ==================================================== ======== ======= */

UPropval::UPropval(const UFlag& _f) : flag(&_f) {}

UPropval& upropval(const class UFlag& _f) {
  return *new UPropval(_f);
}

void UPropval::update() {
  parents.updateParents(UUpdate::all);
}

void UPropval::putProp(UContext *ctx, UCtrl *state) {
  if (flag) {
    const UPropdef* fd = ctx->getPropdef(flag);
    if (fd && fd->getProp()) fd->getProp()->putProp(ctx, state);
  }
}

/* ==================================================== [TheEnd] ======= */
/* ==================================================== [Elc:03] ======= */
