
// Copyright (c) 1995-2003 The University of Cincinnati.
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
// OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY
// LICENSEE AS A RESULT OF USING, RESULT OF USING, MODIFYING OR
// DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the U.S.,
// and the terms of this license.

// You may modify, distribute, and use the software contained in this
// package under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE"
// version 2, June 1991. A copy of this license agreement can be found in
// the file "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	philip.wilsey@ieee.org
//          Dale E. Martin	dmartin@cliftonlabs.com

//---------------------------------------------------------------------------
// 
// $Id: std_textioPkg.hh,v 1.1 2003/12/04 19:13:19 dmartin Exp $
// 
//---------------------------------------------------------------------------

// The fact that this file is currently named std_textioPkg.hh is
// misleading due to the fact that it's hand-rolled and not at all what
// scram would generate for the VHDL package std.textio.  Eventually it
// will be.  DEM - 5/13/2003

#ifndef STD_TEXTIOPKG_HH
#define STD_TEXTIOPKG_HH

#include "tyvis/std_standardPkg.hh"
#include <ctype.h>

extern EnumerationTypeInfo SavantsideType_info;
extern IntegerTypeInfo SavantwidthType_info;

class VHDLKernel;
class SharedFileType;

extern int savantread(VHDLKernel*, AccessVariable &, 
		      const PhysicalType&);  

extern int savantwrite(VHDLKernel*, AccessVariable &, 
		       const PhysicalType&,
		       const VHDLData::Side_t = VHDLData::RIGHT, 
		       const int = 0, VHDLData::TimeUnit_t = VHDLData::NS);

extern int savantread(VHDLKernel*, AccessVariable &, VHDLVTime&);

extern int savantwrite(VHDLKernel*, AccessVariable &, const VHDLVTime&, 
		       const VHDLData::Side_t = VHDLData::RIGHT,
		       const int = 0, 
		       VHDLData::TimeUnit_t = VHDLData::NS);

extern int savantread(VHDLKernel*, AccessVariable &,
		      EnumerationType&);
extern int savantwrite(VHDLKernel*, AccessVariable & line, 
		       const EnumerationType& var,
		       const VHDLData::Side_t = VHDLData::RIGHT, 
		       const int field = 0);

extern int savantread(VHDLKernel*, AccessVariable &, 
		      IntegerType&);
extern int savantwrite(VHDLKernel*, AccessVariable &, 
		       const IntegerType&,
		       const VHDLData::Side_t = VHDLData::RIGHT, 
		       const int = 0);

extern int savantwrite(VHDLKernel*, AccessVariable &, 
		       const RealType&,
		       const VHDLData::Side_t = VHDLData::RIGHT, 
		       const int = 0, const int = 0);
extern int savantread(VHDLKernel*, AccessVariable &, 
		       RealType&);

extern int savantread(VHDLKernel&, AccessVariable &, VHDLType &);
extern int savantread(VHDLKernel*, AccessVariable &, 
		      ArrayType&);
extern int savantread(VHDLKernel*, AccessVariable &, 
		      RecordType&);
extern int savantwrite(VHDLKernel*, AccessVariable & line, 
		       const VHDLType& var,
		       const VHDLData::Side_t = VHDLData::RIGHT, 
		       const int field = 0);
extern int savantwrite(VHDLKernel*, AccessVariable & line, 
		       const ArrayType& var,
		       const VHDLData::Side_t = VHDLData::RIGHT, 
		       const int field = 0);
extern int savantwrite(VHDLKernel*, AccessVariable & line, 
		       const RecordType& var,
		       const VHDLData::Side_t = VHDLData::RIGHT, 
		       const int field = 0);

// Modified from here

extern int savantwrite(VHDLKernel*, AccessType &, 
		       const PhysicalType&,
		       const VHDLData::Side_t = VHDLData::RIGHT, 
		       const int = 0, VHDLData::TimeUnit_t = VHDLData::NS);

extern int savantwrite(VHDLKernel *base, AccessType &line,
		       const VHDLVTime &time,
		       const VHDLData::Side_t side = VHDLData::RIGHT, 
		       const int i = 0, VHDLData::TimeUnit_t t_unit = VHDLData::NS);

extern int savantwrite(VHDLKernel*, AccessType &line, 
		       const EnumerationType& var,
		       const VHDLData::Side_t = VHDLData::RIGHT, 
		       const int = 0);

extern int savantwrite(VHDLKernel*, AccessType &, 
		       const EnumerationType&,
		       const VHDLData::Side_t justified, 
		       const IntegerType&);

extern int savantwrite(VHDLKernel *base, AccessType &line,
		       const IntegerType &var,
		       const VHDLData::Side_t = VHDLData::RIGHT,
		       const int field = 0);

extern int savantwrite(VHDLKernel*, AccessType &line,
		       const RealType&,
		       const VHDLData::Side_t = VHDLData::RIGHT, 
		       const int = 0);

extern int savantwrite(VHDLKernel*, AccessType &line,
		       const VHDLType&,
		       const VHDLData::Side_t = VHDLData::RIGHT, 
		       const int = 0);
extern int savantwrite(VHDLKernel*, AccessType &line,
		       const ArrayType&,
		       const VHDLData::Side_t = VHDLData::RIGHT, 
		       const int = 0);
extern int savantwrite(VHDLKernel*, AccessType &line,
		       const RecordType&,
		       const VHDLData::Side_t = VHDLData::RIGHT, 
		       const int = 0);

extern int savantread(VHDLKernel*, AccessType &, 
		      PhysicalType&);
extern int savantread(VHDLKernel*, AccessType&, EnumerationType&);
extern int savantread(VHDLKernel*, AccessType&,
		      IntegerType&);
extern int savantread(VHDLKernel*, AccessType&,
		      EnumerationType&);
extern int savantread(VHDLKernel*, AccessType&,
		      RealType&);

extern int savantread(VHDLKernel*, AccessType&, VHDLType&);
extern int savantread(VHDLKernel*, AccessType&,
		      ArrayType&);
extern int savantread(VHDLKernel*, AccessType&,
		      RecordType&);

// Second set of modifications start here

extern int savantwrite(VHDLKernel*, AccessType &, 
		       const PhysicalType&, const EnumerationType&,  
		       const IntegerType&, const PhysicalType&);

extern int savantwrite(VHDLKernel *base, AccessType& line,
		       const VHDLVTime &time, const EnumerationType&, 
		       const IntegerType&,
		       VHDLData::TimeUnit_t t_unit = VHDLData::NS);

extern int savantwrite(VHDLKernel*, AccessType& line, 
		       const EnumerationType& var, const EnumerationType&, 
		       const IntegerType&);

extern int savantwrite(VHDLKernel *base, AccessType& line,
		       const IntegerType &var, const EnumerationType&,
		       const IntegerType &);

extern int savantwrite(VHDLKernel*, AccessType& line,
		       const RealType&, const EnumerationType&, 
		       const IntegerType&, const IntegerType&);

extern int savantwrite(VHDLKernel*, AccessType& line,
		       const VHDLType&, const EnumerationType&, 
		       const IntegerType&);

extern int savantwrite(VHDLKernel*, AccessType& line,
		       const ArrayType&, const EnumerationType&, 
		       const IntegerType&);

extern int savantwrite(VHDLKernel*, AccessType& line,
		       const RecordType&, const EnumerationType&, 
		       const IntegerType&);

// Some of the methods that are needed after the scalar types were
// folded into the kernel.

int savantread_bit(VHDLKernel*, AccessVariable &, EnumerationType&);
int savantread_character(VHDLKernel*, AccessVariable &, EnumerationType&);
int savantread_severity_level(VHDLKernel *, AccessVariable &, EnumerationType&);

// The shared file declarations for the input and output

extern SharedFileType* input;
extern SharedFileType* output;

#endif
