#ifndef _SAVANT_FILE_OPEN_KIND_HH
#define _SAVANT_FILE_OPEN_KIND_HH

#include <warped/DeserializerManager.h>
#include <warped/SerializedInstance.h>
#include <iostream>
#include "tyvis/VHDLData.hh"
using std::cout;

class _savant_file_open_kind: public VHDLData {
  friend ostream& operator<<(ostream&, const _savant_file_open_kind&);
public:
  enum FileOpenKind_t { READ_MODE, WRITE_MODE, APPEND_MODE };
  
  FileOpenKind_t val;

  int getIntValue() const { return val; }
  LONG getInt64Value() const { return (LONG)val; }
  double getDoubleValue() const { return (double)val; }

  virtual VHDLData::UniversalType getUniversalKind() const{
    return FILE_OPEN_KIND;
  }

  _savant_file_open_kind() { val = READ_MODE; }
  _savant_file_open_kind(const _savant_file_open_kind& s) : VHDLData() { val = s.val; }
  _savant_file_open_kind(FileOpenKind_t s) { val = s; }
  operator bool() { return val; }

  bool operator==( const RValue &compareTo ) const {
    return val == dynamic_cast<const _savant_file_open_kind &>( compareTo ).val;
  }

  bool operator!=( const RValue &compareTo ) const {
    return val != dynamic_cast<const _savant_file_open_kind &>( compareTo ).val;
  }

  bool operator>( const RValue &compareTo ) const {
    return val > dynamic_cast<const _savant_file_open_kind &>( compareTo ).val;
  }

  bool operator>=( const RValue &compareTo ) const {
    return val >= dynamic_cast<const _savant_file_open_kind &>( compareTo ).val;
  }

  bool operator<( const RValue &compareTo ) const {
    return val < dynamic_cast<const _savant_file_open_kind &>( compareTo ).val;
  }

  bool operator<=( const RValue &compareTo ) const {
    return val <= dynamic_cast<const _savant_file_open_kind &>( compareTo ).val;
  }


  VHDLData& operator=(const VHDLData& d) {
    val = ((_savant_file_open_kind*)&d)->val;
    return *this;
  }
  
  _savant_file_open_kind& operator=(const _savant_file_open_kind& d) {
    val = d.val;
    return *this;
  }
  
  void print(ostream& os = cout) const { os <<*this; os.flush();}

  virtual VHDLData *clone() const {
    return new _savant_file_open_kind( val );
  }

  static const string &getFileOpenKindType(){
    static const string FileOpenKindType = "FileOpenKind";
    return FileOpenKindType;
  }

  const string &getDataType() const {
    return getFileOpenKindType();
  }

  void serialize( SerializedInstance *addTo ) const {
    addTo->addInt( val );
  }

  static Serializable *deserialize( SerializedInstance *si ){
    return new _savant_file_open_kind( FileOpenKind_t(si->getInt()) );
  }

  static void registerDeserializer(){
    DeserializerManager::instance()->registerDeserializer( getFileOpenKindType(),
							   &_savant_file_open_kind::deserialize );
  }

};

inline ostream& operator<<(ostream& os, const _savant_file_open_kind& fok) {
  switch (fok.val) {
  case _savant_file_open_kind::READ_MODE:
    os << "READ_MODE";
    break;
  case _savant_file_open_kind::WRITE_MODE:
    os << "WRITE_MODE";
    break;
  case _savant_file_open_kind::APPEND_MODE:
    os << "APPEND_MODE";
    break;
  default:
    os << "(invalid FileOpenKind type)";
    break;
  }
  return os;
}
#endif
