/**
 Copyright (c) 1995-1999 Ohio Board of Regents and the University of
 Cincinnati.  All Rights Reserved.

 You may modify, distribute, and use the software contained in this package
 under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
 June 1991. A copy of this license agreement can be found in the file
 "LGPL", distributed with this archive.
*/

#ifndef VHDLDATA_HH
#define VHDLDATA_HH
#include <warped/Serializable.h>
#include <sstream>
#include "tyvis/Types.hh"
#include "tyvis/RValue.hh"

class ArrayInfo;
class AccessType;
class EnumerationType;

using std::ostringstream;

class VHDLData : public Serializable, public RValue {
public:
  enum UniversalType {UNIVERSAL_INTEGER, UNIVERSAL_REAL, UNIVERSAL_CHARACTER,
                      UNIVERSAL_BOOLEAN , UNIVERSAL_LONG_LONG_INTEGER, 
		      SEVERITY_LEVEL, FILE_OPEN_KIND, FILE_OPEN_STATUS,
		      ACCESS_VARIABLE, STRING_BASE, CLASS_WIDE, OTHER_TYPE};


  enum Side_t { LEFT, RIGHT };
  enum TimeUnit_t { FS, PS, NS, US, MS, SECONDS, MIN, HR};

  virtual UniversalType getUniversalKind() const = 0;

  virtual int length() const { return 1; }

  virtual void print(ostream& os) const = 0;

  virtual void assignSlice( const VHDLData *, 
			    const ArrayInfo *, 
			    const ArrayInfo * );

  virtual void assignSlice(const VHDLData *, 
			   const ArrayInfo * );

  virtual VHDLData &operator=( const VHDLData & );

  virtual int savantwrite( ostringstream & ) const;
  virtual int savantread(char *);
  virtual int savantread(AccessType &);
  virtual int savantwrite(AccessType &) const;

  virtual bool operator==( const RValue & ) const = 0;
  virtual bool operator!= (const RValue & ) const = 0;
  virtual bool operator> (const RValue &) const = 0;
  virtual bool operator>= (const RValue &) const = 0;
  virtual bool operator< (const RValue &) const = 0;
  virtual bool operator<= (const RValue &) const = 0;
  
  virtual VHDLData *clone() const;

  virtual const VHDLData &readVal() const { return *this; }

  virtual ~VHDLData(){}

  const EnumerationType &vhdlEqual( const RValue & ) const;
  const EnumerationType &vhdlNotEqual( const RValue & ) const;
  const EnumerationType &vhdlGreaterThan( const RValue & ) const;
  const EnumerationType &vhdlGreaterThanEqual( const RValue & ) const;
  const EnumerationType &vhdlLessThan( const RValue & ) const;
  const EnumerationType &vhdlLessThanEqual( const RValue & ) const;

protected:
  VHDLData(){}
};

extern ostream& operator<<(ostream&, const VHDLData&);
extern ostream& operator<<(ostream&, const VHDLData::UniversalType);

void extractToDelimiter(char *source, int delimiter, char *destination);


#endif

