#include "UniversalLongLongInteger.hh"
#include "AccessVariable.hh"
#include "AccessType.hh"
#include "ArrayType.hh"
#include "std_standardPkg.hh"
#include <cmath>
#include <sstream>
using std::ostringstream;
using std::stringstream;

UniversalLongLongInteger
UniversalLongLongInteger::typeCast(VHDLData &toCast){
  switch(toCast.getUniversalKind()){
  case UNIVERSAL_INTEGER:
  case UNIVERSAL_REAL:
  case UNIVERSAL_LONG_LONG_INTEGER:
    return UniversalLongLongInteger(toCast.getInt64Value());
  default:
    cerr << toCast.getUniversalKind() 
	 << " cannot be type casted into an UniversalLongLongInteger ! " << endl;
    return UniversalLongLongInteger(0);
  }
}

UniversalLongLongInteger::UniversalLongLongInteger(const VHDLData &v) {
  this->operator=(v);
}

int
UniversalLongLongInteger::savantwrite(AccessVariable &line) const {
  ostringstream tempStr;
  
  tempStr << line.getVal() << *this << FILE_DELIMITER;
  line.setVal( tempStr.str() );

  return NORMAL_RETURN;
}

int
UniversalLongLongInteger::savantwrite(AccessType &line) const {
  ostringstream tempStr;
  if (line.val != NULL) {
    tempStr << line << *this << FILE_DELIMITER << '\0';
  }
  else {
    tempStr << *this << FILE_DELIMITER << '\0';
  }
      
  if (line.val != NULL) {
    delete line.val;
  }
  
  line.val = new ArrayType( ObjectBase::VARIABLE,
			    SavantstringType_info,
			    -1,
			    tempStr.str().c_str() );

  return NORMAL_RETURN;
}

int
UniversalLongLongInteger::savantread(AccessVariable &) {
  return NORMAL_RETURN;
}

int
UniversalLongLongInteger::savantread( AccessType &line ){
  char *workString = line.val->getString();
  char *input      = new char[strlen(workString) + 1];
  stringstream input_stream;
  
  extractToDelimiter(workString, FILE_DELIMITER, input);

  input_stream << input ;
  input_stream >> this->val;

  delete line.val;

  if (strlen(workString) > 0) {
    line.val = new ArrayType(ObjectBase::VARIABLE, SavantstringType_info, -1, workString);
  }
  else {
    line.val = NULL;
  }

  delete [] workString;
  delete [] input;
    
  return NORMAL_RETURN;
}

const UniversalLongLongInteger &
UniversalLongLongInteger::getMax(){
  static UniversalLongLongInteger max( INT64_MAX );
  return max;
}

const UniversalLongLongInteger &
UniversalLongLongInteger::getMin(){
  static UniversalLongLongInteger max( INT64_MIN );
  return max;
}

UniversalLongLongInteger
UniversalLongLongInteger::vhdlUnaryPlus() const {
  return *this;
}

UniversalLongLongInteger
UniversalLongLongInteger::vhdlUnaryMinus() const {
  return UniversalLongLongInteger( -1 * getInt64Value() );
}


UniversalLongLongInteger
UniversalLongLongInteger::vhdlAbs() const {
  if( getInt64Value() < 0 ){
    return UniversalLongLongInteger(-1*getInt64Value());
  }
  else {
    return UniversalLongLongInteger(getInt64Value());
  }
}

UniversalLongLongInteger
UniversalLongLongInteger::vhdlPlus( const RValue &rhs ) const {
  return UniversalLongLongInteger(getInt64Value() + rhs.getInt64Value());
}

UniversalLongLongInteger
UniversalLongLongInteger::vhdlMinus( const RValue &rhs ) const {
  return UniversalLongLongInteger(getInt64Value() - rhs.getInt64Value());
}

UniversalLongLongInteger
UniversalLongLongInteger::vhdlMultiply( const RValue &rhs) const {
  return UniversalLongLongInteger(getInt64Value() * rhs.getInt64Value());
}

UniversalLongLongInteger
UniversalLongLongInteger::vhdlDivide( const RValue &rhs ) const {
  return UniversalLongLongInteger(getInt64Value() / rhs.getInt64Value());
}

UniversalLongLongInteger
UniversalLongLongInteger::vhdlMod( const RValue &rhs ) const {
  LONG lval = getInt64Value();
  LONG rval = rhs.getInt64Value();
  return UniversalLongLongInteger((lval*rval < 0) ? (rval + lval%rval) : (lval%rval));
}

UniversalLongLongInteger
UniversalLongLongInteger::vhdlRem( const RValue &rhs ) const {
  return UniversalLongLongInteger(getInt64Value() % rhs.getInt64Value());
}

UniversalLongLongInteger
UniversalLongLongInteger::vhdlPow( const RValue &rhs ) const {
  return UniversalLongLongInteger( ::pow( getDoubleValue(),
					  rhs.getDoubleValue()));
}
