#ifndef SHARED_FILETYPE_HH
#define SHARED_FILETYPE_HH

//---------------------------------------------------------------------------
// Copyright (c) 1995-1996 Ohio Board of Regents and the University of
// Cincinnati.  All Rights Reserved.

// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.


//---------------------------------------------------------------------------

#include "tyvis/VHDLKernel.hh"
#include <string>

using std::string;

extern const int maxExtraInFilesInProcedure;
extern const int maxExtraOutFilesInProcedure;

#define SHARED_FILE_HANDLE -2

class SharedFileState : public VHDLKernel_state {
public:
  SharedFileState()  {
    wait = NULL;
  }
  ~SharedFileState() {}

  class SignalBase* locateSig(int);
  void cleanState();

protected:

private:
};

class SharedFileType : public VHDLType, public VHDLKernel {
public:

  SharedFileType(const char *const name, bool alias = false);
  SharedFileType(const SharedFileType &);
  SharedFileType(const char*, const _savant_file_open_kind);
  SharedFileType(const ArrayType&, const _savant_file_open_kind);

  virtual ~SharedFileType();

  virtual Type get_kind() const;

  ObjectBase* getObject() const { return NULL; }

  virtual ObjectBase::ObjectType getKind() const;

  virtual void print(ostream& = cout) const;
  
  VHDLType* clone() const;
  
  EnumerationType savantendfile_boolean(int);
  
  int get_fileHandle() const;
  _savant_file_open_kind& get_fileOpenKind();

  void set_fileOpenKind(const _savant_file_open_kind &);

  VHDLType& operator=(const VHDLType &);
  SharedFileType& operator=(const SharedFileType &);

  bool operator==( const RValue & ) const;
  bool operator!=( const RValue & ) const;
  bool operator>( const RValue & ) const;
  bool operator>=( const RValue & ) const;
  bool operator<( const RValue & ) const;
  bool operator<=( const RValue & ) const;

  _savant_file_open_kind openKind;

  State* allocateState();

  /** This should never be called but has to be here due to pure virtual
      inheritence. */
  void executeVHDL( VHDLKernel_state &currentState, 
		    Block &scalarSignalsUpdateArray,
		    Block &compositeResolvedSignalsUpdateArray );

  const char *getFileName() const { return fileName.c_str(); }

  void initialize();
  void executeProcess();

  void deallocateState( const State *toDealloc ){ delete toDealloc; }
  
protected:

  string fileName;

private:
};

#endif
